/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.library;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IOpaqueBehaviorExecution;
import org.eclipse.papyrus.moka.fuml.library.ILibraryExecutionFactory;
import org.eclipse.papyrus.moka.fuml.loci.ILocus;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.OpaqueBehavior;

public abstract class LibraryExecutionFactory
implements ILibraryExecutionFactory {
    protected URI libraryURI;
    protected Resource libraryResource;
    protected Map<String, OpaqueBehavior> libraryOpaqueBehavior = new HashMap<String, OpaqueBehavior>();
    protected Map<String, Class> libraryService = new HashMap<String, Class>();

    protected void parseLibrary(URI uri, Resource resource) {
        this.libraryURI = uri;
        this.libraryResource = resource;
        if (this.libraryResource != null) {
            this.libraryOpaqueBehavior.clear();
            TreeIterator contentIterator = this.libraryResource.getAllContents();
            while (contentIterator.hasNext()) {
                EObject current = (EObject)contentIterator.next();
                if (!current.eIsProxy() && current instanceof OpaqueBehavior) {
                    this.libraryOpaqueBehavior.put(((OpaqueBehavior)current).getQualifiedName(), (OpaqueBehavior)current);
                    continue;
                }
                if (current.eIsProxy() || current instanceof Behavior || !(current instanceof Class)) continue;
                this.libraryService.put(((Class)current).getQualifiedName(), (Class)current);
            }
        }
    }

    protected void register(IOpaqueBehaviorExecution execution, ILocus locus) {
        if (locus != null && execution != null) {
            locus.getFactory().addPrimitiveBehaviorPrototype(execution);
        }
    }
}

