/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.kernel.scheduling.control;

import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.papyrus.moka.kernel.scheduling.control.ExecutionQueue;
import org.eclipse.papyrus.moka.kernel.scheduling.control.FIFOSchedulingStrategy;
import org.eclipse.papyrus.moka.kernel.scheduling.control.IScheduler;
import org.eclipse.papyrus.moka.kernel.scheduling.control.ISchedulingStrategy;
import org.eclipse.papyrus.moka.kernel.scheduling.execution.ITaskExecution;
import org.eclipse.papyrus.moka.kernel.scheduling.execution.ITaskExecutionCondition;
import org.eclipse.papyrus.moka.kernel.scheduling.execution.TaskExecutionStatus;

public class Scheduler
implements IScheduler {
    protected ExecutionQueue taskQueue = new ExecutionQueue();
    protected ReentrantLock taskQueueLock = new ReentrantLock(true);
    protected ISchedulingStrategy strategy = new FIFOSchedulingStrategy();
    private ITaskExecution currentTask = null;

    @Override
    public void setStrategy(ISchedulingStrategy s) {
        if (s != null) {
            this.strategy = s;
        }
    }

    @Override
    public ITaskExecution next() {
        this.taskQueueLock.lock();
        this.currentTask = this.strategy.select(this.taskQueue);
        this.taskQueueLock.unlock();
        return this.currentTask;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = false;
        this.taskQueueLock.lock();
        hasNext = !this.taskQueue.isEmpty();
        this.taskQueueLock.unlock();
        return hasNext;
    }

    @Override
    public void schedule(ITaskExecution task) {
        if (task != null && this.taskQueueLock.tryLock()) {
            this.taskQueue.offer(task);
            task.setStatus(TaskExecutionStatus.SCHEDULED);
            this.taskQueueLock.unlock();
        }
    }

    @Override
    public void terminate() {
        if (this.currentTask != null) {
            this.currentTask.terminate();
            this.currentTask = null;
        }
        this.taskQueueLock.lock();
        Iterator<ITaskExecution> it = this.taskQueue.iterator();
        while (it.hasNext()) {
            ITaskExecution task = it.next();
            task.terminate();
            task.setStatus(TaskExecutionStatus.TERMINATED);
            it.remove();
        }
        this.taskQueueLock.unlock();
    }

    @Override
    public void terminate(ITaskExecutionCondition condition) {
        if (this.currentTask != null && condition.evaluate(this.currentTask)) {
            this.currentTask.terminate();
            this.currentTask = null;
        }
        this.taskQueueLock.lock();
        Iterator<ITaskExecution> it = this.taskQueue.iterator();
        while (it.hasNext()) {
            ITaskExecution task = it.next();
            if (!condition.evaluate(task)) continue;
            task.terminate();
            task.setStatus(TaskExecutionStatus.TERMINATED);
            it.remove();
        }
        this.taskQueueLock.unlock();
    }

    @Override
    public void suspend() {
        if (this.currentTask != null) {
            this.currentTask.suspend();
            this.currentTask.setStatus(TaskExecutionStatus.SUSPENDED);
        }
        this.taskQueueLock.lock();
        for (ITaskExecution task : this.taskQueue) {
            task.suspend();
            task.setStatus(TaskExecutionStatus.SUSPENDED);
        }
        this.taskQueueLock.unlock();
    }

    @Override
    public void suspend(ITaskExecutionCondition condition) {
        if (this.currentTask != null && condition.evaluate(this.currentTask)) {
            this.currentTask.suspend();
            this.currentTask.setStatus(TaskExecutionStatus.SUSPENDED);
        }
        this.taskQueueLock.lock();
        for (ITaskExecution task : this.taskQueue) {
            if (!condition.evaluate(task)) continue;
            task.suspend();
            task.setStatus(TaskExecutionStatus.SUSPENDED);
        }
        this.taskQueueLock.unlock();
    }

    @Override
    public void resume() {
        if (this.currentTask != null) {
            this.currentTask.setStatus(TaskExecutionStatus.SCHEDULED);
            this.currentTask.resume();
        }
        this.taskQueueLock.lock();
        for (ITaskExecution task : this.taskQueue) {
            task.setStatus(TaskExecutionStatus.SCHEDULED);
            task.resume();
        }
        this.taskQueueLock.unlock();
    }

    @Override
    public void resume(ITaskExecutionCondition condition) {
        if (this.currentTask != null && condition.evaluate(this.currentTask)) {
            this.currentTask.setStatus(TaskExecutionStatus.SCHEDULED);
            this.currentTask.resume();
        }
        this.taskQueueLock.lock();
        for (ITaskExecution task : this.taskQueue) {
            if (!condition.evaluate(task)) continue;
            task.setStatus(TaskExecutionStatus.SCHEDULED);
            task.resume();
        }
        this.taskQueueLock.unlock();
    }
}

