/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.launch;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class MokaStringFileSelector
extends StringEditor {
    private Button browseWorkspace;
    private List<String> filterNames;
    private List<String> filterExtensions;
    private boolean readOnly = false;
    private String defaultFileName;
    private String fileExtension;

    public MokaStringFileSelector(Composite parent, int style, String label) {
        this(parent, style, label, "fileName");
    }

    public MokaStringFileSelector(Composite parent, int style, String label, String defaultFileName) {
        super(parent, style, label);
        this.defaultFileName = defaultFileName;
        ((GridLayout)this.getLayout()).numColumns = 4;
        this.browseWorkspace = factory.createButton((Composite)this, "Browse...", 8);
        this.browseWorkspace.setLayoutData((Object)new GridData());
        this.filterNames = new LinkedList<String>();
        this.filterExtensions = new LinkedList<String>();
        this.browseWorkspace.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                int code;
                LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
                try {
                    labelProviderService.startService();
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                }
                ILabelProvider labelProvider = labelProviderService.getLabelProvider();
                IFile currentFile = FileUtil.getIFile((String)MokaStringFileSelector.this.text.getText());
                TreeSelectorDialog dialog = new TreeSelectorDialog(MokaStringFileSelector.this.getShell());
                if (MokaStringFileSelector.this.labelText != null) {
                    dialog.setTitle(MokaStringFileSelector.this.labelText);
                }
                WorkspaceContentProvider contentProvider = new WorkspaceContentProvider();
                if (!MokaStringFileSelector.this.filterExtensions.isEmpty() && !MokaStringFileSelector.this.filterNames.isEmpty()) {
                    contentProvider.setExtensionFilters(new LinkedHashMap());
                    int i = 0;
                    while (i < Math.min(MokaStringFileSelector.this.filterNames.size(), MokaStringFileSelector.this.filterExtensions.size())) {
                        contentProvider.addExtensionFilter(MokaStringFileSelector.this.filterExtensions.get(i), MokaStringFileSelector.this.filterNames.get(i));
                        ++i;
                    }
                }
                dialog.setContentProvider((ITreeContentProvider)contentProvider);
                dialog.setLabelProvider(labelProvider);
                if (currentFile != null && currentFile.exists()) {
                    dialog.setInitialSelections(new Object[]{currentFile});
                }
                if ((code = dialog.open()) == 0 && (result = dialog.getResult()).length > 0) {
                    Object file = result[0];
                    if (file instanceof IFile) {
                        MokaStringFileSelector.this.setResult((IFile)file);
                    } else if (file instanceof IResource) {
                        MokaStringFileSelector.this.setResult((IResource)file);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void setResult(IFile file) {
        this.text.setText(file.getFullPath().toString());
        this.notifyChange();
    }

    protected void setResult(IResource folder) {
        StringBuilder builder = new StringBuilder();
        builder.append(folder.getFullPath().toString());
        builder.append(File.separator);
        builder.append(this.defaultFileName);
        builder.append(".");
        builder.append(this.fileExtension);
        this.text.setText(builder.toString());
        this.notifyChange();
    }

    protected void setResult(String path) {
        this.text.setText(path);
        this.notifyChange();
    }

    public void setFilters(String[] filterExtensions, String[] filterNames) {
        if (filterExtensions.length != filterNames.length) {
            Activator.log.warn(Messages.StringFileSelector_0);
        }
        this.setFilterNames(this.getFilterLabels(filterNames, filterExtensions));
        this.setFilterExtensions(filterExtensions);
    }

    protected String[] getFilterLabels(String[] filterNames, String[] filterExtensions) {
        int size = Math.min(filterNames.length, filterExtensions.length);
        String[] filters = new String[size];
        int i = 0;
        while (i < size) {
            filters[i] = String.valueOf(filterNames[i]) + " (" + filterExtensions[i] + ")";
            ++i;
        }
        return filters;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = Arrays.asList(filterExtensions);
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = Arrays.asList(filterNames);
    }

    protected void updateFileExtension(String fileExtension) {
        Path path = new Path(this.text.getText());
        path = path.removeFileExtension();
        path = path.addFileExtension(fileExtension);
        this.text.setText(path.toString());
    }

    public void addFilteredExtension(String filteredExtension, String filterName) {
        if (filteredExtension != null) {
            if (filterName == null) {
                filterName = filteredExtension;
            }
            this.filterExtensions.add(filteredExtension);
            this.filterNames.add(filterName);
        }
    }

    public Object getEditableType() {
        return String.class;
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.readOnly = readOnly;
        this.updateButtons();
    }

    private void updateButtons() {
        boolean enableWorkspace = !this.readOnly;
        this.browseWorkspace.setEnabled(enableWorkspace);
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
        this.updateFileExtension(fileExtension);
    }
}

