/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.grid.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.resize.command.AutoResizeColumnsCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.InitializeAutoResizeColumnsCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class InitializeAutoResizeColumnsCommandHandler
extends AbstractLayerCommandHandler<InitializeAutoResizeColumnsCommand> {
    private SelectionLayer selectionLayer;

    public InitializeAutoResizeColumnsCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<InitializeAutoResizeColumnsCommand> getCommandClass() {
        return InitializeAutoResizeColumnsCommand.class;
    }

    @Override
    protected boolean doCommand(InitializeAutoResizeColumnsCommand initCommand) {
        int columnPosition = initCommand.getColumnPosition();
        if (this.selectionLayer.isColumnPositionFullySelected(columnPosition)) {
            initCommand.setSelectedColumnPositions(this.selectionLayer.getFullySelectedColumnPositions());
        } else {
            initCommand.setSelectedColumnPositions(new int[]{columnPosition});
        }
        initCommand.getSourceLayer().doCommand(new AutoResizeColumnsCommand(initCommand));
        return true;
    }
}

