/*****************************************************************************
 * Copyright (c) 2017 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.uml.diagram.common.keyword;

/**
 * UML keywords are reserved words that are an integral part of the UML notation and normally appear as text
 * annotations attached to a UML graphic element or as part of a text line in a UML diagram.
 * See Table C.1 Keywords in OMG Unified Modeling Language TM (OMG UML) Version 2.5
 * 
 * @author Francois Le Fevre - francois.le-fevre@cea.fr
 * @since 3.1
 */
public class KeywordLabel {

	public static final String ABSTRACTION = "abstraction"; //$NON-NLS-1$

	public static final String DEPLOY = "deploy"; //$NON-NLS-1$

	public static final String EXTEND = "extend"; //$NON-NLS-1$

	public static final String FLOW = "flow"; //$NON-NLS-1$

	public static final String IMPORT = "import"; //$NON-NLS-1$

	public static final String INCLUDE = "include"; //$NON-NLS-1$

	public static final String MANIFEST = "manifest"; //$NON-NLS-1$

	public static final String MERGE = "merge"; //$NON-NLS-1$

	public static final String SUBSTITUTE = "substitute"; //$NON-NLS-1$

	public static final String USE = "use"; //$NON-NLS-1$

}
