/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.plugin.CompleteOCLRegistryReader;

public class CompleteOCLRegistry {
    public static final @NonNull CompleteOCLRegistry INSTANCE = new CompleteOCLRegistry(null);
    private final @NonNull Map<String, Set<URI>> nsURI2resourceURIs = new HashMap<String, Set<URI>>();
    private @Nullable Map<Registration, Integer> registrations = null;

    public CompleteOCLRegistry() {
        this(new HashMap<Registration, Integer>());
    }

    protected CompleteOCLRegistry(@Nullable Map<Registration, Integer> registrations) {
        this.registrations = registrations;
    }

    public synchronized void addRegistration(@NonNull Registration registration) {
        Integer count;
        Map<Registration, Integer> registrations2 = this.registrations;
        if (registrations2 == null) {
            this.registrations = registrations2 = new HashMap<Registration, Integer>();
        }
        count = (count = registrations2.get(registration)) == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        registrations2.put(registration, count);
        if (count == 1) {
            this.addRegistrationInternal(registration);
        }
    }

    private void addRegistrationInternal(@NonNull Registration registration) {
        for (String nsURI : registration.nsURIs) {
            Set<URI> resourceURIs = this.nsURI2resourceURIs.get(nsURI);
            if (resourceURIs == null) {
                resourceURIs = new HashSet<URI>();
                this.nsURI2resourceURIs.put(nsURI, resourceURIs);
            }
            resourceURIs.add(registration.resourceURI);
        }
    }

    public synchronized void clear() {
        Map<Registration, Integer> registrations2 = this.registrations;
        if (registrations2 != null) {
            registrations2.clear();
            this.rebuild();
        }
    }

    public @NonNull Set<URI> getResourceURIs(@NonNull ResourceSet resourceSet) {
        if (this.registrations == null) {
            this.registrations = new HashMap<Registration, Integer>();
            new CompleteOCLRegistryReader(this).readRegistry();
        }
        HashSet<String> nsURIs = new HashSet<String>();
        for (Resource resource : resourceSet.getResources()) {
            TreeIterator tit = resource.getAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                EPackage ePackage = eObject.eClass().getEPackage();
                String nsURI = ePackage.getNsURI();
                nsURIs.add(nsURI);
            }
        }
        return this.getResourceURIs(nsURIs);
    }

    public @NonNull Set<URI> getResourceURIs(@NonNull Iterable<String> nsURIs) {
        HashSet<URI> documentURIs = new HashSet<URI>();
        for (String nsURI : nsURIs) {
            Set<URI> resourceURIs;
            if (nsURI == null || (resourceURIs = this.nsURI2resourceURIs.get(nsURI)) == null) continue;
            documentURIs.addAll(resourceURIs);
        }
        return documentURIs;
    }

    private void rebuild() {
        this.nsURI2resourceURIs.clear();
        Map<Registration, Integer> registrations2 = this.registrations;
        if (registrations2 != null) {
            for (Registration registration : registrations2.keySet()) {
                this.addRegistrationInternal(registration);
            }
        }
    }

    public synchronized void removeRegistration(@NonNull Registration registration) {
        Integer count;
        Map<Registration, Integer> registrations2 = this.registrations;
        if (registrations2 != null && (count = registrations2.get(registration)) != null) {
            if ((count = Integer.valueOf(count - 1)) <= 0) {
                registrations2.remove(registration);
                this.rebuild();
            } else {
                registrations2.put(registration, count);
            }
        }
    }

    public static class Registration {
        private @NonNull URI resourceURI;
        private @NonNull Set<String> nsURIs;

        public Registration(@NonNull URI resourceURI, @NonNull Iterable<String> nsURIs) {
            this.resourceURI = resourceURI;
            this.nsURIs = new HashSet<String>();
            for (String nsURI : nsURIs) {
                this.nsURIs.add(nsURI);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Registration)) {
                return false;
            }
            Registration that = (Registration)obj;
            return this.resourceURI.equals(that.resourceURI) && this.nsURIs.equals(that.nsURIs);
        }

        public int hashCode() {
            int hash = this.resourceURI.hashCode();
            for (String nsURI : this.nsURIs) {
                hash += nsURI.hashCode();
            }
            return hash;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.resourceURI);
            s.append(" : ");
            boolean isFirst = true;
            for (String nsURI : this.nsURIs) {
                if (!isFirst) {
                    s.append(",");
                }
                s.append(nsURI);
                isFirst = false;
            }
            return s.toString();
        }
    }
}

