/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.manager.Orphanage;
import org.eclipse.ocl.pivot.internal.resource.AbstractASSaver;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public class ASSaverNew
extends AbstractASSaver {
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EcoreUtil.Copier copier;

    public ASSaverNew(@NonNull ASResource resource) {
        super((Resource)resource);
        this.copier = this.createCopier(resource);
    }

    public @Nullable EObject basicGetTarget(@NonNull EObject source) {
        return (EObject)this.copier.get((Object)source);
    }

    protected @NonNull ASSaverCopier createCopier(@NonNull ASResource resource) {
        return new ASSaverCopier(resource, true);
    }

    public @NonNull EObject getTarget(@NonNull EObject source) {
        return ClassUtil.nonNullState((EObject)this.copier.get((Object)source));
    }

    protected void loadOrphanage(@NonNull Package localOrphanage, @NonNull Orphanage sharedOrphanage) {
        HashMap<@NonNull TypeId, @NonNull Class> typeId2globalType = new HashMap<TypeId, Class>();
        HashMap<@NonNull OperationId, @NonNull Operation> operationId2globalOperation = new HashMap<OperationId, Operation>();
        for (Class asClass : PivotUtil.getOwnedClasses(sharedOrphanage)) {
            if (!"$$".equals(asClass.getName())) {
                TypeId typeId = asClass.getTypeId();
                Class old = typeId2globalType.put(typeId, asClass);
                assert (old == null);
                continue;
            }
            for (Operation asOperation : PivotUtil.getOwnedOperations(asClass)) {
                Operation old = operationId2globalOperation.put(asOperation.getOperationId(), asOperation);
                assert (old == null);
            }
        }
        for (Class asLocalClass : PivotUtil.getOwnedClasses(localOrphanage)) {
            if (!"$$".equals(asLocalClass.getName())) {
                Class asGlobalClass = (Class)typeId2globalType.get(asLocalClass.getTypeId());
                if (asGlobalClass == null) continue;
                this.copier.put((Object)asGlobalClass, (Object)asLocalClass);
                continue;
            }
            for (Operation asLocalOperation : PivotUtil.getOwnedOperations(asLocalClass)) {
                Operation asGlobalOperation = (Operation)operationId2globalOperation.get(asLocalOperation.getOperationId());
                if (asGlobalOperation == null) continue;
                this.copier.put((Object)asGlobalOperation, (Object)asLocalOperation);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void localizeOrphans() {
        Model asModel = PivotUtil.getModel(this.resource);
        Package localOrphanPackage = Orphanage.basicGetLocalOrphanPackage(asModel);
        Orphanage sharedOrphanage = Orphanage.getOrphanage(this.resource.getResourceSet());
        if (localOrphanPackage != null) {
            this.loadOrphanage(localOrphanPackage, sharedOrphanage);
        }
        @NonNull Object moreObjects = this.resource.getContents();
        while (moreObjects != null) {
            Map references = EcoreUtil.CrossReferencer.find((Collection)moreObjects);
            moreObjects = null;
            block1: for (EObject eObject : references.keySet()) {
                assert (eObject != null);
                EObject eContainer = eObject;
                while (eContainer != null) {
                    if (eContainer == sharedOrphanage) {
                        EObject eSource;
                        if (localOrphanPackage == null) {
                            localOrphanPackage = Orphanage.createLocalOrphanPackage(asModel);
                        }
                        if ((eSource = eObject) instanceof Property) {
                            eSource = eSource.eContainer();
                        }
                        if (this.copier.containsKey((Object)eSource)) continue block1;
                        assert (eSource != null);
                        EObject localEObject = this.copier.copy(eSource);
                        if (moreObjects == null) {
                            moreObjects = new ArrayList();
                        }
                        moreObjects.add(eSource);
                        if (localEObject instanceof Class) {
                            localOrphanPackage.getOwnedClasses().add((Class)localEObject);
                            continue block1;
                        }
                        if (!(eSource instanceof Operation)) continue block1;
                        throw new UnsupportedOperationException();
                    }
                    if (eContainer == localOrphanPackage) continue block1;
                    eContainer = eContainer.eContainer();
                }
            }
        }
        this.copier.copyReferences();
        if (localOrphanPackage != null) {
            ECollections.sort((EList)((EList)localOrphanPackage.getOwnedClasses()), (Comparator)new ClassByTypeIdAndEntryClassComparator());
        }
    }

    public @Nullable EObject resolveOrphan(@NonNull EObject eObject) {
        EObject localEObject = (EObject)this.copier.get((Object)eObject);
        EObject eObject2 = localEObject != null ? localEObject : eObject;
        return eObject2;
    }

    protected static class ASSaverCopier
    extends EcoreUtil.Copier {
        protected ASSaverCopier(@NonNull ASResource resource, boolean resolveProxies) {
            super(resolveProxies);
        }

        public EObject copy(EObject eObject) {
            assert (!(eObject instanceof TemplateParameter));
            return super.copy(eObject);
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eReference.isMany() && eReference.getEOpposite() == null) {
                List copyValues = (List)copyEObject.eGet((EStructuralFeature)eReference);
                copyValues.clear();
            }
            super.copyReference(eReference, eObject, copyEObject);
        }
    }

    public static class ASSaverWithInverse
    extends ASSaverNew {
        private final @NonNull Map<@NonNull EObject, @NonNull EObject> target2source = new HashMap<EObject, EObject>();

        public ASSaverWithInverse(@NonNull ASResource resource) {
            super(resource);
        }

        public @Nullable EObject basicGetSource(@NonNull EObject target) {
            return this.target2source.get(target);
        }

        @Override
        protected @NonNull ASSaverCopier createCopier(@NonNull ASResource resource) {
            return new ASSaverCopier(resource, true){

                public EObject put(EObject key, EObject value) {
                    if (!($assertionsDisabled || key != null && value != null)) {
                        throw new AssertionError();
                    }
                    EObject old = target2source.put(value, key);
                    if (!$assertionsDisabled && old != null) {
                        throw new AssertionError();
                    }
                    return (EObject)super.put((Object)key, (Object)value);
                }
            };
        }

        public @NonNull EObject getSource(@NonNull EObject target) {
            return ClassUtil.nonNullState(this.target2source.get(target));
        }
    }

    protected static class ClassByTypeIdAndEntryClassComparator
    implements Comparator<Class> {
        protected ClassByTypeIdAndEntryClassComparator() {
        }

        @Override
        public int compare(@NonNull Class o1, @NonNull Class o2) {
            String s2;
            TypeId t1 = o1.getTypeId();
            TypeId t2 = o2.getTypeId();
            String s1 = t1.toString();
            int compareTo = s1.compareTo(s2 = t2.toString());
            if (compareTo != 0) {
                return compareTo;
            }
            if (o1 instanceof MapType && o2 instanceof MapType) {
                Class ec1 = ((MapType)o1).getEntryClass();
                Class ec2 = ((MapType)o2).getEntryClass();
                if (ec1 == null) {
                    if (ec2 != null) {
                        return -1;
                    }
                } else {
                    if (ec2 == null) {
                        return 1;
                    }
                    t1 = ec1.getTypeId();
                    t2 = ec2.getTypeId();
                    s1 = t1.toString();
                    s2 = t2.toString();
                    compareTo = s1.compareTo(s2);
                }
            }
            return compareTo;
        }
    }
}

