/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.hyperlink.commands.DeleteHyperLinkDocumentCommand;
import org.eclipse.papyrus.infra.hyperlink.commands.EmptyAllHyperLinkCommand;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkException;

public class HyperLinkHelperFactory {
    protected List<AbstractHyperLinkHelper> hyperLinkHelpers = new ArrayList<AbstractHyperLinkHelper>();

    public List<AbstractHyperLinkHelper> getHyperLinkHelpers() {
        return this.hyperLinkHelpers;
    }

    public HyperLinkHelperFactory(List<AbstractHyperLinkHelper> hyperLinkHelpers) {
        this.hyperLinkHelpers.clear();
        this.hyperLinkHelpers.addAll(hyperLinkHelpers);
    }

    public Command getAddHyperLinkCommand(TransactionalEditingDomain domain, EModelElement object, List<HyperLinkObject> hyperlinkObjects) throws HyperLinkException {
        CompoundCommand cmpCommand = new CompoundCommand(Messages.HyperLinkHelperFactory_addHyperLinksCommand);
        for (HyperLinkObject hyperlinkObject : hyperlinkObjects) {
            RecordingCommand cmd = null;
            int i = 0;
            while (cmd == null && i < this.hyperLinkHelpers.size()) {
                cmd = this.hyperLinkHelpers.get(i).getAddHyperLinkCommand(domain, object, hyperlinkObject);
                ++i;
            }
            if (cmd == null) {
                throw new HyperLinkException(String.valueOf(Messages.HyperLinkHelperFactory_ImpossibleToFindACommandToSerialize) + hyperlinkObject);
            }
            cmpCommand.append(cmd);
        }
        return cmpCommand.isEmpty() ? null : cmpCommand;
    }

    public static RecordingCommand getRemoveHyperlinkCommand(TransactionalEditingDomain domain, EModelElement object, String localization) {
        return new DeleteHyperLinkDocumentCommand(domain, object, localization);
    }

    public ArrayList<?> getAllreferenced(EModelElement object) throws HyperLinkException {
        ArrayList<HyperLinkObject> result = new ArrayList<HyperLinkObject>();
        for (EAnnotation currentAnnotation : object.getEAnnotations()) {
            int i = 0;
            HyperLinkObject hyperlinkObject = null;
            while (hyperlinkObject == null && i < this.hyperLinkHelpers.size()) {
                hyperlinkObject = this.hyperLinkHelpers.get(i).getHyperLinkObject(currentAnnotation);
                ++i;
            }
            if (hyperlinkObject == null) continue;
            result.add(hyperlinkObject);
        }
        return result;
    }

    public static EmptyAllHyperLinkCommand getEmptyAllHyperLinkCommand(TransactionalEditingDomain domain, EModelElement object) {
        return new EmptyAllHyperLinkCommand(domain, object);
    }
}

