/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.editor.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.editor.Activator;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalization;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class RenameNestedEditorCommand
extends AbstractHandler {
    public void setEnabled(Object evaluationContext) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        return null;
    }

    public void execute(final Diagram diagram, IEditorPart editorPart) {
        TransactionalEditingDomain editingDomain = null;
        if (editorPart instanceof IAdaptable) {
            ServicesRegistry registry = (ServicesRegistry)editorPart.getAdapter(ServicesRegistry.class);
            if (registry == null) {
                editingDomain = (TransactionalEditingDomain)editorPart.getAdapter(TransactionalEditingDomain.class);
            } else {
                try {
                    editingDomain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)registry);
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                }
            }
        }
        if (editingDomain != null) {
            String diagramLabel = LabelInternationalization.getInstance().getDiagramLabelWithoutName(diagram);
            if (diagramLabel != null) {
                InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Rename diagram label", "New label:", diagramLabel, null);
                if (dialog.open() == 0) {
                    String label = dialog.getValue();
                    editingDomain.getCommandStack().execute(LabelInternationalization.getInstance().getSetDiagramLabelCommand((EditingDomain)editingDomain, diagram, label, null));
                }
            } else {
                String name;
                InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Rename an existing diagram", "New name:", diagram.getName(), null);
                if (dialog.open() == 0 && (name = dialog.getValue()) != null && name.length() > 0) {
                    RecordingCommand command = new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            diagram.setName(name);
                        }
                    };
                    editingDomain.getCommandStack().execute((Command)command);
                }
            }
        }
    }
}

