/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.canonical.strategy;

import com.google.common.base.Strings;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.canonical.internal.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;

abstract class Registration<T, R extends Registration<? extends T, R>>
implements Comparable<R> {
    private static final String ENABLEMENT = "enablement";
    private static final String CLASS = "class";
    private static final String PRIORITY = "priority";
    private final IConfigurationElement config;
    private final Class<? extends T> extensionType;
    private final int priority;
    private final Expression filterExpression;
    private T extension;
    private IStatus extensionFailure;

    protected Registration(IConfigurationElement config, Class<? extends T> extensionType) throws CoreException {
        this.config = config;
        this.extensionType = extensionType;
        this.filterExpression = Registration.parseExpression(config, ENABLEMENT);
        this.priority = Registration.parseInt(config, PRIORITY);
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(R o) {
        return this.getPriority() - ((Registration)o).getPriority();
    }

    public boolean isApplicableTo(EditPart editPart) {
        boolean result;
        boolean bl = result = !this.hasFilterExpression();
        if (!result) {
            try {
                EObject element;
                EvaluationContext context = new EvaluationContext(null, (Object)editPart);
                View view = NotationHelper.findView((Object)editPart);
                if (view != null && (element = view.getElement()) != null) {
                    context.addVariable("editPart", (Object)editPart);
                    context.addVariable("view", (Object)view);
                    context.addVariable("element", (Object)element);
                    result = EvaluationResult.TRUE.equals(this.filterExpression.evaluate((IEvaluationContext)context));
                }
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
        return result;
    }

    protected boolean hasFilterExpression() {
        return this.filterExpression != null;
    }

    protected final IConfigurationElement getConfigurationElement() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension() {
        T result = this.extension;
        if (result == null && this.extensionFailure == null) {
            Registration registration = this;
            synchronized (registration) {
                try {
                    Object instance = this.config.createExecutableExtension(CLASS);
                    if (!this.extensionType.isInstance(instance)) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.gmfdiag.canonical", "Extension is not an instance of " + this.extensionType.getClass().getName()));
                    }
                    if (this.extension == null) {
                        this.extension = this.extensionType.cast(instance);
                    }
                }
                catch (CoreException e) {
                    this.extensionFailure = e.getStatus();
                    Activator.log.error("Failed to instantiate extension.", (Throwable)e);
                }
                result = this.extension;
            }
        }
        return result;
    }

    static int parseInt(IConfigurationElement config, String attribute) {
        int result = 0;
        String attrValue = config.getAttribute(attribute);
        if (!Strings.isNullOrEmpty((String)attrValue)) {
            try {
                result = Integer.parseInt(attrValue);
            }
            catch (Exception e) {
                Activator.log.warn(String.format("Not an integer value in '%s' attribute of '%s' element from plug-in '%s': %s", attribute, config.getName(), config.getContributor().getName(), attrValue));
            }
        }
        return result;
    }

    static Expression parseExpression(IConfigurationElement config, String elementName) throws CoreException {
        Expression result = null;
        IConfigurationElement[] enablement = config.getChildren(elementName);
        if (enablement.length > 0) {
            result = ExpressionConverter.getDefault().perform(enablement[0]);
        }
        return result;
    }
}

