/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.papyrus.toolsmiths.profilemigration.Activator;
import org.eclipse.papyrus.toolsmiths.profilemigration.factory.IMigratorFactory;
import org.eclipse.papyrus.toolsmiths.profilemigration.factory.MigratorFactory;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationRegistry;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.extensionPoint.AtomicMigratorRegistry;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.AtomicMigratorComparator;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.DifferenceTreeBuilder;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.ICompositeMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.IAtomicMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.dialogs.ProfileMigrationToolConfigurationDialog;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.preferences.ProfileMigrationPreferencePage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class MigratorProfileApplication {
    public static Package profiledModel;
    public static Profile appliedProfile;
    public static Comparison comparison;
    public static Set<Profile> newAppliedProfile;
    public static List<EObject> newStereotypeApplication;
    protected List<IAtomicMigrator> atomicList = new ArrayList<IAtomicMigrator>();
    protected List<ICompositeMigrator> compositeList = new ArrayList<ICompositeMigrator>();
    private static Map<String, String> cacheProfileToFile;

    static {
        newAppliedProfile = new HashSet<Profile>();
        newStereotypeApplication = new ArrayList<EObject>();
        cacheProfileToFile = new HashMap<String, String>();
    }

    public List<EObject> reapplyProfile(Package package_, Profile profile) {
        Resource profileBeforeResource;
        String path;
        Resource profileAfterResource;
        block9: {
            block8: {
                profileAfterResource = profile.eResource();
                path = null;
                profileBeforeResource = null;
                if (this.isAlreadyInCached(profile, profileAfterResource)) break block8;
                ProfileMigrationToolConfigurationDialog dialog = new ProfileMigrationToolConfigurationDialog(MigratorProfileApplication.getActiveShell(), profile.getQualifiedName());
                int dialogResult = dialog.open();
                switch (dialogResult) {
                    case 0: {
                        path = dialog.getFilePath();
                        if (path != null && path != "") {
                            URI uri = URI.createFileURI((String)path);
                            ResourceSetImpl profileBeforeResourceSet = new ResourceSetImpl();
                            profileBeforeResource = profileBeforeResourceSet.getResource(uri, true);
                            this.saveNewFileInCache(path, profileBeforeResource);
                        }
                        break block9;
                    }
                    case 3: {
                        package_.applyProfile(profile);
                        return newStereotypeApplication;
                    }
                    default: {
                        return newStereotypeApplication;
                    }
                }
            }
            try {
                path = cacheProfileToFile.get(((XMIResource)profileAfterResource).getID((EObject)profile));
                URI uri = URI.createFileURI((String)path);
                ResourceSetImpl profileBeforeResourceSet = new ResourceSetImpl();
                profileBeforeResource = profileBeforeResourceSet.getResource(uri, true);
            }
            catch (WrappedException e) {
                this.removeFilePathFromCached(path);
                this.reapplyProfile(package_, profile);
            }
        }
        if (path != null && profileBeforeResource != null) {
            this.migrateNewAppliedProfile(package_, profile, profileBeforeResource, profileAfterResource);
        }
        return newStereotypeApplication;
    }

    public Package migrateNewAppliedProfile(Package package_, Profile profile, Resource profileBeforeResource, Resource profileAfterResource) {
        profiledModel = package_;
        appliedProfile = profile;
        newAppliedProfile.clear();
        try {
            TreeNode rootTreeNode = this.getTreeNode((Notifier)profileBeforeResource, (Notifier)profileAfterResource);
            if (rootTreeNode != null) {
                new StereotypeApplicationRegistry(rootTreeNode, profiledModel);
                this.migrateNewAppliedProfile(profiledModel, rootTreeNode, profile, true);
            } else {
                profiledModel.applyProfile(profile);
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        return profiledModel;
    }

    protected TreeNode getTreeNode(Notifier before, Notifier after) {
        DefaultComparisonScope scope = new DefaultComparisonScope(after, before, null);
        EMFCompare comparator = EMFCompare.builder().build();
        comparison = comparator.compare((IComparisonScope)scope);
        DifferenceTreeBuilder builder = new DifferenceTreeBuilder(comparison);
        TreeNode differenceTree = builder.buildMatchTree();
        return differenceTree;
    }

    protected void migrateNewAppliedProfile(Package model, TreeNode treeNode, Profile profile, boolean shouldReapply) {
        this.atomicList.clear();
        this.compositeList.clear();
        this.initAtomicList(treeNode, MigratorFactory.INSTANCE);
        this.initCompositeList();
        this.postProcessing();
        if (shouldReapply) {
            model.applyProfile(appliedProfile);
        }
        for (IAtomicMigrator atomic : this.atomicList) {
            atomic.migrationAction();
        }
        for (Profile newProfile : newAppliedProfile) {
            newAppliedProfile.remove(newProfile);
            this.migrateNewAppliedProfile(model, treeNode, newProfile, false);
        }
    }

    protected void initAtomicList(TreeNode treeNode, IMigratorFactory migratorFactory) {
        this.atomicList.addAll(migratorFactory.instantiateMigrator(treeNode));
        for (TreeNode childNode : treeNode.getChildren()) {
            this.initAtomicList(childNode, migratorFactory);
        }
        this.atomicList.sort(new AtomicMigratorComparator());
    }

    private void postProcessing() {
        ArrayList<IAtomicMigrator> toRemove = new ArrayList<IAtomicMigrator>();
        for (AtomicMigratorRegistry.Descriptor descriptor : AtomicMigratorRegistry.INSTANCE.getRegistry()) {
            for (String replacement : descriptor.getErasedMigrators()) {
                for (IAtomicMigrator migrator : this.atomicList) {
                    if (toRemove.contains(migrator) || !migrator.getClass().getName().equals(replacement)) continue;
                    toRemove.add(migrator);
                }
            }
        }
        this.atomicList.removeAll(toRemove);
    }

    protected void initCompositeList() {
    }

    private static Shell getActiveShell() {
        Display display = Display.getDefault();
        Shell result = display.getActiveShell();
        if (result == null) {
            Shell[] shells;
            Shell[] shellArray = shells = display.getShells();
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                if (shell.getShells().length == 0) {
                    result = shell;
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean isAlreadyInCached(Profile profile, Resource profileAfterResource) {
        if (cacheProfileToFile.containsKey(((XMIResource)profileAfterResource).getID((EObject)profile))) {
            String path = cacheProfileToFile.get(((XMIResource)profileAfterResource).getID((EObject)profile));
            if (ProfileMigrationPreferencePage.getCachedFiles().contains(path)) {
                return true;
            }
            cacheProfileToFile.remove(((XMIResource)profileAfterResource).getID((EObject)profile));
            return false;
        }
        return false;
    }

    private void saveNewFileInCache(String path, Resource profileBeforeResource) {
        TreeIterator iter = profileBeforeResource.getAllContents();
        while (iter.hasNext()) {
            EObject object = (EObject)iter.next();
            if (object instanceof Package) {
                if (!(object instanceof Profile)) continue;
                cacheProfileToFile.put(((XMIResource)profileBeforeResource).getID(object), path);
                if (ProfileMigrationPreferencePage.getCachedFiles().contains(path)) continue;
                ProfileMigrationPreferencePage.addFile((String)path);
                continue;
            }
            iter.prune();
        }
    }

    private void removeFilePathFromCached(String path) {
        Iterator<Map.Entry<String, String>> it = cacheProfileToFile.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (!entry.getValue().equals(path)) continue;
            ProfileMigrationPreferencePage.getCachedFiles().remove(path);
            it.remove();
        }
    }
}

