/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.figure.node;

import java.util.Hashtable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IAnchorableFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;

public class PapyrusAnchorableWrappingLabel
extends PapyrusWrappingLabel
implements IAnchorableFigure {
    public static final String szAnchor = "";
    private Hashtable connectionAnchors;

    protected ConnectionAnchor createDefaultAnchor() {
        return new SlidableAnchor((IFigure)this);
    }

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        ConnectionAnchor connectAnchor = (ConnectionAnchor)this.getConnectionAnchors().get(terminal);
        if (connectAnchor == null) {
            if (terminal.equals(szAnchor)) {
                connectAnchor = this.createDefaultAnchor();
                this.getConnectionAnchors().put(terminal, connectAnchor);
            } else {
                connectAnchor = this.createAnchor(BaseSlidableAnchor.parseTerminalString((String)terminal));
            }
        }
        return connectAnchor;
    }

    protected ConnectionAnchor createAnchor(PrecisionPoint p) {
        if (p == null) {
            return this.createDefaultAnchor();
        }
        return new SlidableAnchor((IFigure)this, p);
    }

    protected Hashtable getConnectionAnchors() {
        if (this.connectionAnchors == null) {
            this.connectionAnchors = new Hashtable(1);
        }
        return this.connectionAnchors;
    }

    public String getConnectionAnchorTerminal(ConnectionAnchor c) {
        if (c instanceof SlidableAnchor) {
            return ((SlidableAnchor)c).getTerminal();
        }
        if (this.getConnectionAnchors().containsValue(c)) {
            for (String key : this.getConnectionAnchors().keySet()) {
                if (!this.getConnectionAnchors().get(key).equals(c)) continue;
                return key;
            }
        }
        this.getConnectionAnchor(szAnchor);
        return szAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchorAt(Point p) {
        return this.createConnectionAnchor(p);
    }

    public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
        return this.createConnectionAnchor(p);
    }

    protected ConnectionAnchor createConnectionAnchor(Point p) {
        if (p == null) {
            return this.getConnectionAnchor(szAnchor);
        }
        Point temp = p.getCopy();
        this.translateToRelative((Translatable)temp);
        PrecisionPoint pt = BaseSlidableAnchor.getAnchorRelativeLocation((Point)temp, (Rectangle)this.getBounds());
        if (this.isDefaultAnchorArea(pt)) {
            return this.getConnectionAnchor(szAnchor);
        }
        return this.createAnchor(pt);
    }

    protected boolean isDefaultAnchorArea(PrecisionPoint p) {
        return p.preciseX() >= this.getSlidableAnchorArea() / 2.0 && p.preciseX() <= 1.0 - this.getSlidableAnchorArea() / 2.0 && p.preciseY() >= this.getSlidableAnchorArea() / 2.0 && p.preciseY() <= 1.0 - this.getSlidableAnchorArea() / 2.0;
    }

    protected double getSlidableAnchorArea() {
        return 0.5;
    }
}

