/**
 * Copyright (c) 2015 Anatolyi Tischenko and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Anatolyi Tischenko - Initial API and implementation
 */
package aspects.xpt.diagram.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class ReorientLinkUtils extends xpt.diagram.commands.ReorientLinkUtils {
  @Inject
  @Extension
  private Common _common;
  
  @Override
  public CharSequence canReorient(final LinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean canExecute() {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _checkLinkValidity = this.checkLinkValidity(it);
    _builder.append(_checkLinkValidity, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (reorientDirection == org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRequest.REORIENT_SOURCE) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return canReorientSource();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (reorientDirection == org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRequest.REORIENT_TARGET) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return canReorientTarget();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("protected boolean canReorientSource() {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _checkSourceRequestValidity = this.checkSourceRequestValidity(it, link);
    _builder.append(_checkSourceRequestValidity, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2);
    _builder.newLineIfNotEmpty();
    _builder.append("protected boolean canReorientTarget() {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _checkTargetRequestValidity = this.checkTargetRequestValidity(it, link);
    _builder.append(_checkTargetRequestValidity, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence reorient(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (!canExecute()) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("throw new org.eclipse.core.commands.ExecutionException(\"Invalid arguments in reorient link command\"); ");
    CharSequence _nonNLS = this._common.nonNLS();
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (reorientDirection == org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRequest.REORIENT_SOURCE) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return reorientSource();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (reorientDirection == org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRequest.REORIENT_TARGET) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return reorientTarget();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("throw new IllegalStateException();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult reorientSource() throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _reorientSource = this.reorientSource(it);
    _builder.append(_reorientSource, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult reorientTarget() throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _reorientTarget = this.reorientTarget(it);
    _builder.append(_reorientTarget, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
