/**
 * Copyright (c) 2007, 2010, 2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package aspects.xpt.propsheet;

import aspects.xpt.Common;
import aspects.xpt.editor.VisualIDRegistry;
import aspects.xpt.providers.ElementTypes;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPropertySheet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
@SuppressWarnings("all")
public class LabelProvider extends xpt.propsheet.LabelProvider {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private ElementTypes xptElementTypes;
  
  @Inject
  private VisualIDRegistry visualId;
  
  @Override
  public CharSequence unwrapMethods(final GenPropertySheet it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private Object unwrap(Object element) {");
    _builder.newLine();
    _builder.append("if (element instanceof org.eclipse.jface.viewers.IStructuredSelection) {");
    _builder.newLine();
    _builder.append("return ((org.eclipse.jface.viewers.IStructuredSelection) element).getFirstElement();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("return element;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gmf.runtime.notation.View getView(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (element instanceof org.eclipse.gmf.runtime.notation.View) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return (org.eclipse.gmf.runtime.notation.View) element;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (element instanceof org.eclipse.core.runtime.IAdaptable) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return (org.eclipse.gmf.runtime.notation.View)");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("((org.eclipse.core.runtime.IAdaptable) element).getAdapter(org.eclipse.gmf.runtime.notation.View.class);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gmf.runtime.emf.type.core.IElementType getElementType(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// For intermediate views climb up the containment hierarchy to find the one associated with an element type.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("while (view != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("String vid = ");
    CharSequence _qualifiedClassName = this.visualId.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".getVisualID(view);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType etype =");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    CharSequence _qualifiedClassName_1 = this.xptElementTypes.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName_1, "\t\t\t\t");
    _builder.append(".getElementType(vid);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (etype != null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return etype;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("view = view.eContainer() instanceof org.eclipse.gmf.runtime.notation.View ?");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.View) view.eContainer() : null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
