/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPage;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.IPage;
import org.junit.Assert;

public class ModelExplorerUtils {
    private static final String ModelExplorerViewId = "org.eclipse.papyrus.views.modelexplorer.modelexplorer";

    private ModelExplorerUtils() {
    }

    public static ModelExplorerView openModelExplorerView() throws PartInitException {
        IViewPart modelexplorer = null;
        modelexplorer = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ModelExplorerViewId);
        ModelExplorerPageBookView view = (ModelExplorerPageBookView)modelexplorer;
        IPage currentPage = view.getCurrentPage();
        ModelExplorerPage page = (ModelExplorerPage)currentPage;
        IViewPart viewer = page.getViewer();
        Assert.assertNotNull((Object)viewer);
        viewer.setFocus();
        return (ModelExplorerView)viewer;
    }

    public static void setSelectionInTheModelexplorer(ModelExplorerView view, List<?> elements) {
        view.revealSemanticElement(elements);
        List<?> currentSelection = ModelExplorerUtils.getCurrentSelectionInTheModelExplorer();
        Assert.assertTrue((String)"The current selection is not the wanted selection", (boolean)elements.containsAll(currentSelection));
        Assert.assertTrue((String)"The current selection is not the wanted selection", (boolean)currentSelection.containsAll(elements));
    }

    public static List<?> getCurrentSelectionInTheModelExplorer() {
        ArrayList<Object> selection = new ArrayList<Object>();
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            IStructuredSelection currentSelection = (IStructuredSelection)activeWorkbenchWindow.getSelectionService().getSelection(ModelExplorerViewId);
            for (Object current : currentSelection) {
                EObject eObject = EMFHelper.getEObject(current);
                if (eObject != null) {
                    selection.add(eObject);
                    continue;
                }
                selection.add(current);
            }
        }
        return selection;
    }

    public static final EObject getRootInModelExplorer(ModelExplorerView view) {
        view.getCommonViewer().expandToLevel(2);
        Object[] visibleElement = view.getCommonViewer().getVisibleExpandedElements();
        EObject modelRoot = null;
        if (visibleElement.length > 0) {
            modelRoot = EMFHelper.getEObject((Object)visibleElement[0]);
        }
        Assert.assertNotNull(modelRoot);
        while (modelRoot.eContainer() != null) {
            modelRoot = modelRoot.eContainer();
        }
        return modelRoot;
    }

    public static final void testHandlerStatusInModelExplorer(ModelExplorerView view, String commandToTest, EObject actionContext, boolean wantedResult) {
        ModelExplorerUtils.setSelectionInTheModelexplorer(view, Collections.singletonList(actionContext));
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command cmd = commandService.getCommand(commandToTest);
        IHandler handler = cmd.getHandler();
        if (handler instanceof AbstractHandler) {
            ((AbstractHandler)handler).setEnabled((Object)commandToTest);
        }
        boolean res = handler.isEnabled();
        Assert.assertEquals((Object)wantedResult, (Object)res);
    }

    public static final Object executeCreateNestedEditorHandlerInModelExplorer(final IMultiDiagramEditor currentPapyrusEditor, ModelExplorerView view, String commandToExecute, EObject actionContext, final String bundelID) {
        ModelExplorerUtils.setSelectionInTheModelexplorer(view, Collections.singletonList(actionContext));
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        final Command cmd = commandService.getCommand(commandToExecute);
        final IHandler handler = cmd.getHandler();
        if (handler instanceof AbstractHandler) {
            ((AbstractHandler)handler).setEnabled((Object)commandToExecute);
        }
        RunnableWithResult.Impl<Object> runnableWithResult = new RunnableWithResult.Impl<Object>(){

            public void run() {
                try {
                    handler.execute(new ExecutionEvent(cmd, Collections.emptyMap(), null, null));
                }
                catch (ExecutionException e) {
                    this.setStatus((IStatus)new Status(4, bundelID, e.getMessage()));
                }
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart activeEditor = activePage.getActiveEditor();
                if (currentPapyrusEditor != activeEditor) {
                    this.setStatus((IStatus)new Status(4, bundelID, "The current active editor is not the wanted Papyrus Editor"));
                }
                this.setResult(currentPapyrusEditor.getActiveEditor());
                this.setStatus(Status.OK_STATUS);
            }
        };
        Display.getDefault().syncExec((Runnable)runnableWithResult);
        Assert.assertEquals((String)runnableWithResult.getStatus().getMessage(), (long)0L, (long)runnableWithResult.getStatus().getSeverity());
        Object result = runnableWithResult.getResult();
        Assert.assertNotNull((Object)result);
        return result;
    }
}

