/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import com.google.common.collect.ImmutableSet;
import java.util.function.Function;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.infra.services.edit.utils.ElementTypeUtils;
import org.eclipse.papyrus.uml.diagram.sequence.locator.CenterLocator;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;

public class TimeElementCreationFeedbackEditPolicy
extends GraphicalEditPolicy {
    public static final String ROLE = "TimeElementCreationFeedback";
    private final Function<? super IFigure, ? extends IBorderItemLocator> locatorFunction;
    private IBorderItemLocator locator;
    private IFigure feedback;

    public TimeElementCreationFeedbackEditPolicy() {
        this(fig -> new CenterLocator((IFigure)fig, 0));
    }

    public TimeElementCreationFeedbackEditPolicy(Function<? super IFigure, ? extends IBorderItemLocator> locatorFunction) {
        this.locatorFunction = locatorFunction;
    }

    protected IBorderItemLocator getFeedbackLocator() {
        if (this.locator == null) {
            this.locator = this.locatorFunction.apply((IFigure)this.getFeedbackParent());
        }
        return this.locator;
    }

    IFigure getFeedbackParent() {
        IFigure result = this.getHostFigure();
        if (result instanceof BorderedNodeFigure) {
            result = ((BorderedNodeFigure)result).getMainFigure();
        }
        return result;
    }

    public void showTargetFeedback(Request request) {
        IElementType typeToShow = this.getCreatedElementType(request);
        if (this.isTimeElementType(typeToShow)) {
            IFigure feedback = this.requireFeedback();
            IBorderItemLocator locator = this.getFeedbackLocator();
            Point where = this.getRelativeLocation(request);
            Rectangle proposedLocation = new Rectangle(where, feedback.getSize());
            locator.setConstraint(proposedLocation);
            Rectangle resolved = locator.getValidLocation(proposedLocation, feedback);
            resolved.translate(0, -resolved.height() / 2);
            this.getFeedbackParent().translateToAbsolute((Translatable)resolved);
            this.getFeedbackLayer().translateToRelative((Translatable)resolved);
            feedback.setBounds(resolved);
        }
    }

    protected IElementType getCreatedElementType(Request request) {
        EObject element;
        DropObjectsRequest dropReq;
        IElementType result = null;
        if (request instanceof AspectUnspecifiedTypeCreationTool.CreateAspectUnspecifiedTypeRequest) {
            AspectUnspecifiedTypeCreationTool.CreateAspectUnspecifiedTypeRequest createReq = (AspectUnspecifiedTypeCreationTool.CreateAspectUnspecifiedTypeRequest)request;
            if (createReq.getElementTypes().size() == 1) {
                result = (IElementType)createReq.getElementTypes().get(0);
            }
        } else if (request instanceof DropObjectsRequest && (dropReq = (DropObjectsRequest)request).getObjects().size() == 1 && (element = EMFHelper.getEObject(dropReq.getObjects().get(0))) != null) {
            result = ElementTypeRegistry.getInstance().getElementType(element, ElementTypeUtils.getDefaultClientContext());
        }
        return result;
    }

    protected boolean isTimeElementType(IElementType type) {
        ImmutableSet types;
        boolean result = false;
        if (type != null && !(result = (types = ImmutableSet.of((Object)UMLElementTypes.TIME_CONSTRAINT, (Object)UMLElementTypes.TIME_OBSERVATION)).contains(type)) && type instanceof ISpecializationType) {
            ISpecializationType spec = (ISpecializationType)type;
            result = types.stream().anyMatch(arg_0 -> ((ISpecializationType)spec).isSpecializationOf(arg_0));
        }
        return result;
    }

    protected Point getRelativeLocation(Request request) {
        Point result = null;
        if (request instanceof DropRequest) {
            result = ((DropRequest)request).getLocation();
        }
        if (result != null) {
            result = result.getCopy();
            this.getFeedbackParent().translateToRelative((Translatable)result);
        } else {
            result = new Point();
        }
        return result;
    }

    protected IFigure getFeedback() {
        if (this.feedback == null) {
            this.feedback = new RectangleFigure();
            this.feedback.setForegroundColor(ColorConstants.gray);
            this.feedback.setBackgroundColor(ColorConstants.gray);
            this.feedback.setSize(60, 5);
        }
        return this.feedback;
    }

    protected IFigure requireFeedback() {
        IFigure result = this.getFeedback();
        if (result.getParent() == null) {
            this.addFeedback(result);
        }
        return result;
    }

    public void eraseTargetFeedback(Request request) {
        if (this.feedback != null && this.feedback.getParent() != null) {
            this.removeFeedback(this.feedback);
        }
    }
}

