/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.ui.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.emf.utils.TextReferencesHelper;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.editors.richtext.AbstractToolbarButton;
import org.eclipse.papyrus.infra.widgets.editors.richtext.GenericRichTextEditor;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.ui.Activator;
import org.eclipse.papyrus.uml.ui.editors.UMLRichtextEditorWithReferences;
import org.eclipse.papyrus.uml.ui.messages.Messages;
import org.eclipse.swt.widgets.Display;

public class InsertReferenceToolbarButton
extends AbstractToolbarButton {
    private static final String BUTTON_NAME = "InsertReferenceButton";
    private static final String BUTTON_COMMAND_NAME = "InsertReferenceCommand";
    private static final String BUTTON_LABEL = Messages.InsertReferenceToolbarButton_Tooltip;
    private static final String ICON_PATH = "icons/hyperlink_16x16.gif";

    public InsertReferenceToolbarButton() {
        super(BUTTON_NAME, BUTTON_COMMAND_NAME, BUTTON_LABEL, "links", org.eclipse.papyrus.infra.widgets.Activator.getDefault().getURL(ICON_PATH));
    }

    public Object execute() {
        if (this.richTextEditor == null) {
            Activator.log.warn("The insert references action cannot be executed, because the Richtext editor has not be registered for this action");
        } else if (!(this.richTextEditor instanceof UMLRichtextEditorWithReferences)) {
            Activator.log.warn("The insert references action cannot be executed, because the Richtext editor is not a UMLRichtextEditorWithReferences");
        } else {
            UMLRichtextEditorWithReferences editor = (UMLRichtextEditorWithReferences)this.richTextEditor;
            IStaticContentProvider referenceContentProvider = editor.getContentProvider();
            ILabelProvider labelProvider = editor.getLabelProvider();
            TextReferencesHelper referencesHelper = editor.getTextReferencesHelper();
            if (referenceContentProvider != null && labelProvider != null && referencesHelper != null) {
                TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getDefault().getActiveShell());
                dialog.setContentProvider((ITreeContentProvider)new EncapsulatedContentProvider((IStructuredContentProvider)referenceContentProvider));
                dialog.setLabelProvider(labelProvider);
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    if (result.length == 0) {
                        return null;
                    }
                    Object resultElement = result[0];
                    if (!(resultElement instanceof EObject)) {
                        return null;
                    }
                    EObject objectToReference = (EObject)resultElement;
                    String newText = referencesHelper.insertReference(objectToReference, "", 0);
                    if (this.richTextEditor.isTagsEnabled()) {
                        try {
                            String realName = referencesHelper.replaceReferences(newText).replaceAll("\\<u\\>", "").replaceAll("\\<\\/u\\>", "");
                            String reference = newText.replaceAll("\\{\\@link", "").replaceAll("\\}", "").replaceAll("\\s", "");
                            this.richTextEditor.insertHTML("<a class=\"internal_ref\" href=\"" + reference + "\">" + realName + "</a>");
                        }
                        catch (Exception e) {
                            Activator.log.error((Throwable)e);
                            this.richTextEditor.insertText(newText);
                        }
                    } else {
                        this.richTextEditor.insertText(newText);
                    }
                }
            }
        }
        return null;
    }

    public void setRichTextEditor(GenericRichTextEditor editor) {
        Assert.isTrue((boolean)(editor instanceof UMLRichtextEditorWithReferences));
        super.setRichTextEditor(editor);
    }
}

