/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.toolsmiths.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EAttributeTreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EReferenceTreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EStructuralFeatureTreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.TreeElement;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public class ActionUtil {
    private final EditingDomainActionBarContributor contributor;
    private final Consumer<? super SelectionChangedEvent> selectionChangedHandler;
    private final BiFunction<? super Collection<?>, ? super ISelection, ? extends Collection<IAction>> newChildActionsGenerator;
    private final BiFunction<? super Collection<?>, ? super ISelection, ? extends Collection<IAction>> newSiblingActionsGenerator;
    private ISelection originalSelection;

    public ActionUtil(EditingDomainActionBarContributor contributor, Consumer<? super SelectionChangedEvent> selectionChangedHandler, BiFunction<? super Collection<?>, ? super ISelection, ? extends Collection<IAction>> newChildActionsGenerator, BiFunction<? super Collection<?>, ? super ISelection, ? extends Collection<IAction>> newSiblingActionsGenerator) {
        this.contributor = contributor;
        this.selectionChangedHandler = selectionChangedHandler;
        this.newChildActionsGenerator = newChildActionsGenerator;
        this.newSiblingActionsGenerator = newSiblingActionsGenerator;
    }

    public static Collection<Object> getAdaptedSelection(Collection<? extends Object> selection) {
        LinkedList<Object> newSelection = new LinkedList<Object>();
        for (Object object : selection) {
            EObject semantic = EMFHelper.getEObject((Object)object);
            newSelection.add(semantic == null ? object : semantic);
        }
        return newSelection;
    }

    public static ISelection getAdaptedSelection(ISelection sourceSelection) {
        if (sourceSelection instanceof StructuredSelection) {
            StructuredSelection currentSelection = (StructuredSelection)sourceSelection;
            LinkedList newSelection = new LinkedList();
            for (Object object : currentSelection) {
                EObject eObject = EMFHelper.getEObject(object);
                newSelection.add(eObject == null ? object : eObject);
            }
            StructuredSelection selection = new StructuredSelection(newSelection);
            return selection;
        }
        return sourceSelection;
    }

    public static Object getElement(ISelection selection) {
        IStructuredSelection structured;
        Object result = null;
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
            result = structured.getFirstElement();
        }
        return result;
    }

    public static EObject unwrapTreeNode(ISelection selection) {
        EObject result = null;
        Object firstElement = ActionUtil.getElement(selection);
        if (firstElement instanceof TreeElement) {
            result = ActionUtil.unwrapTreeNode((TreeElement)firstElement);
        }
        return result;
    }

    private static EObject unwrapTreeNode(TreeElement treeElement) {
        EStructuralFeatureTreeElement featureElement;
        EObject result = null;
        if (treeElement instanceof EObjectTreeElement) {
            result = ((EObjectTreeElement)treeElement).getEObject();
        } else if (treeElement instanceof EStructuralFeatureTreeElement && (featureElement = (EStructuralFeatureTreeElement)treeElement).getParent() != null) {
            result = ActionUtil.unwrapTreeNode(featureElement.getParent());
        }
        return result;
    }

    public static EStructuralFeature unwrapTreeFeature(ISelection selection) {
        EStructuralFeature result = null;
        Object firstElement = ActionUtil.getElement(selection);
        if (firstElement instanceof EStructuralFeatureTreeElement) {
            result = ActionUtil.unwrapTreeFeature((EStructuralFeatureTreeElement)firstElement);
        }
        return result;
    }

    private static EStructuralFeature unwrapTreeFeature(EStructuralFeatureTreeElement treeElement) {
        EAttribute result = null;
        if (treeElement instanceof EAttributeTreeElement) {
            result = ((EAttributeTreeElement)treeElement).getEAttribute();
        } else if (treeElement instanceof EReferenceTreeElement) {
            result = ((EReferenceTreeElement)treeElement).getEReference();
        }
        return result;
    }

    public static EStructuralFeature unwrapTreeParentFeature(ISelection selection) {
        EObjectTreeElement object;
        EStructuralFeature result = null;
        Object firstElement = ActionUtil.getElement(selection);
        if (firstElement instanceof EObjectTreeElement && (object = (EObjectTreeElement)firstElement).getParent() instanceof EStructuralFeatureTreeElement) {
            result = ActionUtil.unwrapTreeFeature((EStructuralFeatureTreeElement)object.getParent());
        }
        return result;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.originalSelection = event.getSelection();
        try {
            ISelection newSelection = ActionUtil.getAdaptedSelection(event.getSelection());
            SelectionChangedEvent newEvent = new SelectionChangedEvent(event.getSelectionProvider(), newSelection);
            this.selectionChangedHandler.accept((SelectionChangedEvent)newEvent);
        }
        finally {
            this.originalSelection = null;
        }
    }

    public Collection<IAction> createNewChildActions(Collection<?> descriptors, ISelection selection) {
        Collection<IAction> result;
        EObject unwrappedTreeObject = ActionUtil.unwrapTreeNode(this.originalSelection);
        EStructuralFeature unwrappedTreeFeature = ActionUtil.unwrapTreeFeature(this.originalSelection);
        if (unwrappedTreeObject != null && unwrappedTreeFeature != null) {
            descriptors = this.getEditingDomain().getNewChildDescriptors((Object)unwrappedTreeObject, null);
            descriptors.removeIf(d -> !(d instanceof CommandParameter) || ((CommandParameter)d).getEStructuralFeature() != unwrappedTreeFeature);
            result = this.newChildActionsGenerator.apply(descriptors, (ISelection)new StructuredSelection((Object)unwrappedTreeObject));
        } else {
            result = this.newChildActionsGenerator.apply(descriptors, (ISelection)selection);
        }
        return result;
    }

    public Collection<IAction> createNewSiblingActions(Collection<?> descriptors, ISelection selection) {
        Collection<IAction> result;
        EObject unwrappedTreeObject = ActionUtil.unwrapTreeNode(this.originalSelection);
        EStructuralFeature unwrappedTreeFeature = ActionUtil.unwrapTreeFeature(this.originalSelection);
        EStructuralFeature unwrappedTreeParentFeature = ActionUtil.unwrapTreeParentFeature(this.originalSelection);
        if (unwrappedTreeObject != null && unwrappedTreeFeature != null) {
            descriptors = this.getEditingDomain().getNewChildDescriptors(null, (Object)unwrappedTreeObject);
            descriptors.removeIf(d -> !(d instanceof CommandParameter) || ((CommandParameter)d).getEStructuralFeature() != unwrappedTreeFeature);
            result = this.newSiblingActionsGenerator.apply(descriptors, (ISelection)new StructuredSelection((Object)unwrappedTreeObject));
        } else if (unwrappedTreeObject != null && unwrappedTreeParentFeature != null) {
            descriptors = new ArrayList<Object>(descriptors);
            descriptors.removeIf(d -> !(d instanceof CommandParameter) || ((CommandParameter)d).getEStructuralFeature() != unwrappedTreeParentFeature);
            result = this.newSiblingActionsGenerator.apply(descriptors, (ISelection)new StructuredSelection((Object)unwrappedTreeObject));
        } else {
            result = this.newSiblingActionsGenerator.apply(descriptors, (ISelection)selection);
        }
        return result;
    }

    protected EditingDomain getEditingDomain() {
        return ((IEditingDomainProvider)this.contributor.getActiveEditor()).getEditingDomain();
    }
}

