/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.parameter.celleditors;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.uml2.diagram.common.part.UMLElementChooserDialog;
import org.eclipse.uml2.uml.Type;

public class TypeDialogCellEditor
extends DialogCellEditor {
    private final TransactionalEditingDomain myEditingDomain;
    private final AdapterFactory myAdapterFactory;

    public TypeDialogCellEditor(Table table, TransactionalEditingDomain editingDomain, AdapterFactory af) {
        super((Composite)table, 4);
        this.myEditingDomain = editingDomain;
        this.myAdapterFactory = af;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        TypeChooserDialog dialog = new TypeChooserDialog(cellEditorWindow.getShell(), this.myAdapterFactory);
        if (dialog.open() == 0) {
            URI uri = dialog.getSelectedModelElementURI();
            try {
                return this.myEditingDomain.getResourceSet().getEObject(uri, true);
            }
            catch (WrappedException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private static class TypeChooserDialog
    extends UMLElementChooserDialog {
        public TypeChooserDialog(Shell parentShell, AdapterFactory af) {
            super(parentShell, af);
        }

        protected boolean isValid(EObject selectedElement) {
            return selectedElement instanceof Type;
        }

        protected void setInput(TreeViewer treeViewer) {
            treeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        }
    }
}

