/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.csd.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.csd.expressions.UMLAbstractExpression;
import org.eclipse.uml2.diagram.csd.expressions.UMLOCLFactory;
import org.eclipse.uml2.diagram.csd.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.csd.part.UMLNodeDescriptor;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.uml2.diagram.csd/debug/visualID";
    private static UMLAbstractExpression Class_2006_Constraint;
    private static UMLAbstractExpression Class_2007_Constraint;
    private static UMLAbstractExpression Property_3007_Constraint;
    private static UMLAbstractExpression Property_3008_Constraint;
    private static UMLAbstractExpression Property_3014_Constraint;
    private static UMLAbstractExpression Connector_4005_Constraint;
    private static UMLAbstractExpression Dependency_4006_Constraint;
    private static UMLAbstractExpression InterfaceRealization_4007_Constraint;
    private static UMLAbstractExpression Usage_4008_Constraint;
    private static UMLAbstractExpression Slot_4015_Constraint;

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("UMLCompositeStructures".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLCompositeStructures".equals(containerModelID)) {
            return -1;
        }
        if ("UMLCompositeStructures".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 2005: {
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3013;
            }
            case 2006: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3011;
            }
            case 2007: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3017;
            }
            case 3014: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
            case 7003: {
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3007((Property)domainElement)) break;
                return 3007;
            }
            case 7004: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3008((Property)domainElement)) break;
                return 3008;
            }
            case 7005: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7006: {
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 7002: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 7007: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3014((Property)domainElement)) break;
                return 3014;
            }
            case 7009: {
                if (!UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 1000: {
                if (containerView instanceof Diagram && domainElement != null && domainElement.equals(containerView.getElement())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_2006((Class)domainElement)) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_2007((Class)domainElement)) {
                    return 2007;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2009;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 2011;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 2012;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLCompositeStructures".equals(containerModelID)) {
            return false;
        }
        if ("UMLCompositeStructures".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2005: {
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (7003 == nodeVisualID) {
                    return true;
                }
                if (3013 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5013 == nodeVisualID) {
                    return true;
                }
                if (5014 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (7005 == nodeVisualID) {
                    return true;
                }
                if (7006 == nodeVisualID) {
                    return true;
                }
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (7002 != nodeVisualID) break;
                return true;
            }
            case 2007: {
                if (5018 == nodeVisualID) {
                    return true;
                }
                if (7007 == nodeVisualID) {
                    return true;
                }
                if (3017 != nodeVisualID) break;
                return true;
            }
            case 2009: {
                if (5020 != nodeVisualID) break;
                return true;
            }
            case 2011: {
                if (5022 == nodeVisualID) {
                    return true;
                }
                if (7009 != nodeVisualID) break;
                return true;
            }
            case 2012: {
                if (5024 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (5002 != nodeVisualID) break;
                return true;
            }
            case 3007: {
                if (5011 != nodeVisualID) break;
                return true;
            }
            case 3013: {
                if (5016 != nodeVisualID) break;
                return true;
            }
            case 3011: {
                if (5012 == nodeVisualID) {
                    return true;
                }
                if (5026 != nodeVisualID) break;
                return true;
            }
            case 3014: {
                if (5017 == nodeVisualID) {
                    return true;
                }
                if (3016 != nodeVisualID) break;
                return true;
            }
            case 3016: {
                if (5025 != nodeVisualID) break;
                return true;
            }
            case 3017: {
                if (5027 == nodeVisualID) {
                    return true;
                }
                if (5028 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3010 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3004 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2007 == nodeVisualID) {
                    return true;
                }
                if (2009 == nodeVisualID) {
                    return true;
                }
                if (2011 == nodeVisualID) {
                    return true;
                }
                if (2012 != nodeVisualID) break;
                return true;
            }
            case 4005: {
                if (6009 == nodeVisualID) {
                    return true;
                }
                if (6010 == nodeVisualID) {
                    return true;
                }
                if (6011 == nodeVisualID) {
                    return true;
                }
                if (6012 == nodeVisualID) {
                    return true;
                }
                if (6013 == nodeVisualID) {
                    return true;
                }
                if (6014 == nodeVisualID) {
                    return true;
                }
                if (6015 != nodeVisualID) break;
                return true;
            }
            case 4006: {
                if (6001 != nodeVisualID) break;
                return true;
            }
            case 4011: {
                if (6002 == nodeVisualID) {
                    return true;
                }
                if (6003 == nodeVisualID) {
                    return true;
                }
                if (6004 == nodeVisualID) {
                    return true;
                }
                if (6005 == nodeVisualID) {
                    return true;
                }
                if (6006 == nodeVisualID) {
                    return true;
                }
                if (6007 == nodeVisualID) {
                    return true;
                }
                if (6008 != nodeVisualID) break;
                return true;
            }
            case 4015: {
                if (6016 == nodeVisualID) {
                    return true;
                }
                if (6017 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getConnector().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConnector_4005((Connector)domainElement)) {
            return 4005;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDependency_4006((Dependency)domainElement)) {
            return 4006;
        }
        if (UMLPackage.eINSTANCE.getInterfaceRealization().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInterfaceRealization_4007((InterfaceRealization)domainElement)) {
            return 4007;
        }
        if (UMLPackage.eINSTANCE.getUsage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isUsage_4008((Usage)domainElement)) {
            return 4008;
        }
        if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass())) {
            return 4011;
        }
        if (UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isSlot_4015((Slot)domainElement)) {
            return 4015;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean isClass_2006(Class domainElement) {
        Object result;
        if (Class_2006_Constraint == null) {
            Class_2006_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::AssociationClass) and not oclIsKindOf(uml::StateMachine)", (EClassifier)UMLPackage.eINSTANCE.getClass_());
        }
        return (result = Class_2006_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isClass_2007(Class domainElement) {
        Object result;
        if (Class_2007_Constraint == null) {
            Class_2007_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::AssociationClass) and not oclIsKindOf(uml::StateMachine)", (EClassifier)UMLPackage.eINSTANCE.getClass_());
        }
        return (result = Class_2007_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_3007(Property domainElement) {
        Object result;
        if (Property_3007_Constraint == null) {
            Property_3007_Constraint = UMLOCLFactory.getExpression("not self.oclIsKindOf(uml::Port)", (EClassifier)UMLPackage.eINSTANCE.getProperty());
        }
        return (result = Property_3007_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_3008(Property domainElement) {
        Object result;
        if (Property_3008_Constraint == null) {
            Property_3008_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::Port)", (EClassifier)UMLPackage.eINSTANCE.getProperty());
        }
        return (result = Property_3008_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_3014(Property domainElement) {
        Object result;
        if (Property_3014_Constraint == null) {
            Property_3014_Constraint = UMLOCLFactory.getExpression("not self.oclIsKindOf(uml::Port)", (EClassifier)UMLPackage.eINSTANCE.getProperty());
        }
        return (result = Property_3014_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isConnector_4005(Connector domainElement) {
        Object result;
        if (Connector_4005_Constraint == null) {
            Connector_4005_Constraint = UMLOCLFactory.getExpression("kind =ConnectorKind::delegation", (EClassifier)UMLPackage.eINSTANCE.getConnector());
        }
        return (result = Connector_4005_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDependency_4006(Dependency domainElement) {
        Object result;
        if (Dependency_4006_Constraint == null) {
            Dependency_4006_Constraint = UMLOCLFactory.getExpression("not self.oclIsKindOf(uml::Usage) and not self.oclIsKindOf(uml::InterfaceRealization)", (EClassifier)UMLPackage.eINSTANCE.getDependency());
        }
        return (result = Dependency_4006_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInterfaceRealization_4007(InterfaceRealization domainElement) {
        Object result;
        if (InterfaceRealization_4007_Constraint == null) {
            InterfaceRealization_4007_Constraint = UMLOCLFactory.getExpression("self.supplier->forAll(e|e.oclIsKindOf(uml::Interface))", (EClassifier)UMLPackage.eINSTANCE.getInterfaceRealization());
        }
        return (result = InterfaceRealization_4007_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isUsage_4008(Usage domainElement) {
        Object result;
        if (Usage_4008_Constraint == null) {
            Usage_4008_Constraint = UMLOCLFactory.getExpression("self.supplier->forAll(e|e.oclIsKindOf(uml::Interface)) and self.client->forAll(e|not e.oclIsKindOf(uml::Port))", (EClassifier)UMLPackage.eINSTANCE.getUsage());
        }
        return (result = Usage_4008_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isSlot_4015(Slot domainElement) {
        Object result;
        if (Slot_4015_Constraint == null) {
            Slot_4015_Constraint = UMLOCLFactory.getExpression("self.value->exists(v : ValueSpecification | v.oclIsKindOf(InstanceValue) and not v.oclAsType(InstanceValue).oclIsUndefined())", (EClassifier)UMLPackage.eINSTANCE.getSlot());
        }
        return (result = Slot_4015_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    protected static boolean hasViewChild(View containerView, EObject domainElement, int visualId) {
        if (domainElement == null) {
            return false;
        }
        for (Object next : containerView.getChildren()) {
            View nextView = (View)next;
            if (!domainElement.equals(nextView.getElement()) || !UMLVisualIDRegistry.getType(visualId).equals(nextView.getType())) continue;
            return true;
        }
        return false;
    }

    public static int getChildDescriptorVisualID(UMLNodeDescriptor container, EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        switch (container.getVisualID()) {
            case 2005: {
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3007((Property)domainElement)) break;
                return 3007;
            }
            case 2006: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3008((Property)domainElement)) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 2003: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 2007: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3017;
                }
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3014((Property)domainElement)) break;
                return 3014;
            }
            case 2011: {
                if (!UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 3014: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
            case 1000: {
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_2006((Class)domainElement)) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_2007((Class)domainElement)) {
                    return 2007;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2009;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 2011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2012;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3007((Property)domainElement)) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3008((Property)domainElement)) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3014((Property)domainElement)) {
                    return 3014;
                }
                if (!UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
        }
        return -1;
    }
}

