/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.component.edit.parts;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.editparts.PrimaryShapeEditPart;
import org.eclipse.uml2.diagram.component.edit.parts.ComponentContentsEditPart;
import org.eclipse.uml2.diagram.component.edit.parts.ComponentName2EditPart;
import org.eclipse.uml2.diagram.component.edit.parts.PortEditPart;
import org.eclipse.uml2.diagram.component.edit.policies.ComponentCanonicalEditPolicy;
import org.eclipse.uml2.diagram.component.edit.policies.ComponentItemSemanticEditPolicy;
import org.eclipse.uml2.diagram.component.part.UMLVisualIDRegistry;

public class ComponentEditPart
extends AbstractBorderedShapeEditPart
implements PrimaryShapeEditPart {
    public static final int VISUAL_ID = 2001;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public ComponentEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ComponentItemSemanticEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new ComponentCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof IBorderItemEditPart) {
                    return new BorderItemSelectionEditPolicy();
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        ComponentFigure figure = new ComponentFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public ComponentFigure getPrimaryShape() {
        return (ComponentFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ComponentName2EditPart) {
            ((ComponentName2EditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureComponentFigure_name());
            return true;
        }
        if (childEditPart instanceof ComponentContentsEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getFigureComponentFigure_Body();
            this.setupContentPane((IFigure)pane);
            pane.add(((ComponentContentsEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof PortEditPart) {
            BorderItemLocator locator = new BorderItemLocator(this.getMainFigure(), 0);
            this.getBorderedFigure().getBorderItemContainer().add(((PortEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ComponentContentsEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getFigureComponentFigure_Body();
            pane.remove(((ComponentContentsEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof PortEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((PortEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof ComponentContentsEditPart) {
            return this.getPrimaryShape().getFigureComponentFigure_Body();
        }
        if (editPart instanceof PortEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return super.getContentPaneFor(editPart);
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(100), this.getMapMode().DPtoLP(40));
        return result;
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5001));
    }

    protected void reorderChild(EditPart child, int index) {
        IFigure childFigure = ((GraphicalEditPart)child).getFigure();
        LayoutManager layout = this.getContentPaneFor((IGraphicalEditPart)child).getLayoutManager();
        Object constraint = null;
        if (layout != null) {
            constraint = layout.getConstraint(childFigure);
        }
        super.reorderChild(child, index);
        this.setLayoutConstraint(child, childFigure, constraint);
    }

    public class ComponentFigure
    extends RectangleFigure {
        private Label fFigureComponentFigure_name;
        private RectangleFigure fFigureComponentFigure_Body;
        private boolean myUseLocalCoordinates = false;

        public ComponentFigure() {
            BorderLayout layoutThis = new BorderLayout();
            this.setLayoutManager((LayoutManager)layoutThis);
            this.setFill(false);
            this.setOutline(false);
            this.createContents();
        }

        private void createContents() {
            RectangleFigure componentFigure_LabelsContainer0 = new RectangleFigure();
            componentFigure_LabelsContainer0.setMinimumSize(new Dimension(ComponentEditPart.this.getMapMode().DPtoLP(0), ComponentEditPart.this.getMapMode().DPtoLP(35)));
            this.add((IFigure)componentFigure_LabelsContainer0, BorderLayout.TOP);
            ToolbarLayout layoutComponentFigure_LabelsContainer0 = new ToolbarLayout();
            layoutComponentFigure_LabelsContainer0.setStretchMinorAxis(true);
            layoutComponentFigure_LabelsContainer0.setMinorAlignment(0);
            layoutComponentFigure_LabelsContainer0.setSpacing(0);
            layoutComponentFigure_LabelsContainer0.setVertical(true);
            componentFigure_LabelsContainer0.setLayoutManager((LayoutManager)layoutComponentFigure_LabelsContainer0);
            Label componentFigure_fixed_component1 = new Label();
            componentFigure_fixed_component1.setText("\u00abcomponent\u00bb");
            componentFigure_LabelsContainer0.add((IFigure)componentFigure_fixed_component1);
            this.fFigureComponentFigure_name = new Label();
            this.fFigureComponentFigure_name.setText("");
            componentFigure_LabelsContainer0.add((IFigure)this.fFigureComponentFigure_name);
            this.fFigureComponentFigure_Body = new RectangleFigure();
            this.fFigureComponentFigure_Body.setMinimumSize(new Dimension(ComponentEditPart.this.getMapMode().DPtoLP(0), ComponentEditPart.this.getMapMode().DPtoLP(55)));
            this.add((IFigure)this.fFigureComponentFigure_Body, BorderLayout.CENTER);
        }

        public Label getFigureComponentFigure_name() {
            return this.fFigureComponentFigure_name;
        }

        public RectangleFigure getFigureComponentFigure_Body() {
            return this.fFigureComponentFigure_Body;
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }
    }
}

