/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class ProvidedPortLinkHelper {
    private final AdapterFactoryEditingDomain myEditingDomain;
    private final EObject mySource;
    private final EObject myTarget;

    public ProvidedPortLinkHelper(AdapterFactoryEditingDomain editingDomain, EObject source, EObject target) {
        this.myEditingDomain = editingDomain;
        this.mySource = source;
        this.myTarget = target;
    }

    public void create() {
        Port port = this.getSource();
        Interface targetInterface = this.getTarget();
        if (port == null || targetInterface == null) {
            return;
        }
        Type portType = port.getType();
        if (portType == null) {
            port.setType((Type)targetInterface);
            return;
        }
        if (portType instanceof Classifier) {
            this.createRealization(port, targetInterface, (Classifier)portType);
        }
    }

    private Realization createRealization(Port port, Interface targetInterface, Classifier portType) {
        Package realizationContainer = null;
        Port element = this.getSource();
        while (element != null) {
            if (element instanceof Package) {
                realizationContainer = (Package)element;
                break;
            }
            element = element.eContainer();
        }
        if (realizationContainer == null) {
            return null;
        }
        InterfaceRealization realization = UMLFactory.eINSTANCE.createInterfaceRealization();
        realizationContainer.getPackagedElements().add((Object)realization);
        realization.getClients().add((Object)portType);
        realization.getSuppliers().add((Object)targetInterface);
        return realization;
    }

    public boolean canCreate() {
        return true;
    }

    private Port getSource() {
        return (Port)this.mySource;
    }

    private Interface getTarget() {
        return (Interface)this.myTarget;
    }
}

