/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;

public class RequiredPortLinkHelper {
    private final AdapterFactoryEditingDomain myEditingDomain;
    private final EObject mySource;
    private final EObject myTarget;

    public RequiredPortLinkHelper(AdapterFactoryEditingDomain editingDomain, EObject source, EObject target) {
        this.myEditingDomain = editingDomain;
        this.mySource = source;
        this.myTarget = target;
    }

    public void create() {
        if (this.getSource() == null || this.getTarget() == null || this.getSource().getType() == null) {
            return;
        }
        Type type = this.getSource().getType();
        if (type instanceof Classifier && !(type instanceof Interface)) {
            Classifier classifier = (Classifier)type;
            classifier.createUsage((NamedElement)this.getTarget());
        }
    }

    public boolean canCreate() {
        if (this.getSource() == null) {
            return true;
        }
        Type type = this.getSource().getType();
        if (type == null) {
            return false;
        }
        if (!(type instanceof Classifier) || type instanceof Interface) {
            return false;
        }
        boolean isReadOnly = this.myEditingDomain.isReadOnly(type.eResource());
        return !isReadOnly;
    }

    private Port getSource() {
        return (Port)this.mySource;
    }

    private Interface getTarget() {
        return (Interface)this.myTarget;
    }
}

