/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.editpolicies;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.notation.NotationPackage;

public class DynamicResizeDirectionsEditPolicy
extends ResizableShapeEditPolicy
implements NotificationListener {
    private static final int VERTICAL = -1;
    private static final int SQUARE = 0;
    private static final int HORIZONTAL = 1;
    private int myCurrentState = -1;

    public DynamicResizeDirectionsEditPolicy() {
        this.setResizeDirections(5);
    }

    public void activate() {
        super.activate();
        this.getDiagramEventBroker().addNotificationListener((EObject)this.getHostImpl().getNotationView(), (NotificationListener)this);
    }

    public void deactivate() {
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.getHostImpl().getNotationView(), (NotificationListener)this);
        super.deactivate();
    }

    public void hostSizeChanged() {
        IGraphicalEditPart host = this.getHostImpl();
        Integer width = (Integer)host.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        Integer height = (Integer)host.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        if (width == null) {
            width = 0;
        }
        if (height == null) {
            height = 0;
        }
        Dimension size = new Dimension(width.intValue(), height.intValue());
        this.correctEditPolicy(size);
    }

    public void notifyChanged(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getSize_Width().equals(feature) || NotationPackage.eINSTANCE.getSize_Height().equals(feature)) {
            this.hostSizeChanged();
        }
    }

    private void correctEditPolicy(Dimension size) {
        if (this.isChanged(size)) {
            this.hideSelection();
            this.setState(size);
            this.showSelection();
        }
    }

    private IGraphicalEditPart getHostImpl() {
        return (IGraphicalEditPart)this.getHost();
    }

    private boolean isChanged(Dimension size) {
        return (size.height - size.width) * this.myCurrentState > 0;
    }

    private void setState(Dimension size) {
        int delta = size.height - size.width;
        if (delta > 0) {
            this.myCurrentState = -1;
            this.setResizeDirections(5);
        } else if (delta < 0) {
            this.myCurrentState = 1;
            this.setResizeDirections(24);
        } else {
            this.myCurrentState = 0;
        }
    }

    private DiagramEventBroker getDiagramEventBroker() {
        return DiagramEventBroker.getInstance((TransactionalEditingDomain)this.getHostImpl().getEditingDomain());
    }
}

