/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.parser.property;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.diagram.parser.AbstractToString;
import org.eclipse.uml2.diagram.parser.ExternalToString;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public abstract class PropertyToString
extends AbstractToString {
    private static final Property DEFAULT_VALUES_PROTOTYPE = UMLFactory.eINSTANCE.createProperty();

    protected Property asProperty(EObject object) {
        if (!(object instanceof Property)) {
            throw new IllegalStateException("I can not provide toString for: " + object);
        }
        return (Property)object;
    }

    protected void appendPropertyModifiers(StringBuffer result, Property property) {
        String nextName;
        AbstractToString.ModifiersBuilder builder = new AbstractToString.ModifiersBuilder();
        if (property.isReadOnly()) {
            builder.appendModifier("readOnly");
        }
        if (property.isDerivedUnion()) {
            builder.appendModifier("union");
        }
        if (property.isOrdered()) {
            builder.appendModifier("ordered");
        }
        if (property.isUnique() != DEFAULT_VALUES_PROTOTYPE.isUnique()) {
            builder.appendModifier(property.isUnique() ? "unique" : "nonunique");
        }
        for (Property next : property.getSubsettedProperties()) {
            nextName = next.getName();
            if (PropertyToString.isEmpty((String)nextName)) continue;
            builder.appendModifier("subsets " + nextName);
        }
        for (Property next : property.getRedefinedProperties()) {
            nextName = next.getName();
            if (PropertyToString.isEmpty((String)nextName)) continue;
            builder.appendModifier("redefines " + nextName);
        }
        builder.writeInto(result);
    }

    protected void appendDefault(StringBuffer result, Property property) {
        String def = property.getDefault();
        if (PropertyToString.isEmpty((String)def)) {
            return;
        }
        result.append(" = ");
        result.append(def);
    }

    protected void appendVisibility(StringBuffer result, Property property) {
        result.append(this.getVisibility((NamedElement)property));
    }

    protected void appendIsDerived(StringBuffer result, Property property) {
        result.append(property.isDerived() ? "/" : "");
    }

    public static class EDIT
    extends PropertyToString {
        public String getToString(EObject object, int flags) {
            Property property = this.asProperty(object);
            StringBuffer result = new StringBuffer();
            this.appendVisibility(result, property);
            this.appendIsDerived(result, property);
            this.appendName(result, (NamedElement)property);
            this.appendType(result, (TypedElement)property);
            this.appendMultiplicity(result, (MultiplicityElement)property);
            this.appendDefault(result, property);
            this.appendPropertyModifiers(result, property);
            return result.toString();
        }

        public boolean isAffectingFeature(EStructuralFeature feature) {
            throw new UnsupportedOperationException("I am edit toString, I am not expected to be asked");
        }
    }

    public static class VIEW
    extends PropertyToString
    implements ExternalToString.WithReferences {
        private static final List AFFECTING = Arrays.asList(UMLPackage.eINSTANCE.getNamedElement_Visibility(), UMLPackage.eINSTANCE.getProperty_IsDerived(), UMLPackage.eINSTANCE.getProperty_DefaultValue(), UMLPackage.eINSTANCE.getNamedElement_Name(), UMLPackage.eINSTANCE.getTypedElement_Type(), UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue(), UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue(), UMLPackage.eINSTANCE.getLiteralUnlimitedNatural_Value(), UMLPackage.eINSTANCE.getLiteralInteger_Value(), UMLPackage.eINSTANCE.getLiteralString_Value());

        public String getToString(EObject object, int flags) {
            Property property = this.asProperty(object);
            StringBuffer result = new StringBuffer();
            switch (flags) {
                case 1: {
                    this.appendName(result, (NamedElement)property);
                    this.appendType(result, (TypedElement)property);
                    break;
                }
                default: {
                    this.appendVisibility(result, property);
                    this.appendIsDerived(result, property);
                    this.appendName(result, (NamedElement)property);
                    this.appendType(result, (TypedElement)property);
                    this.appendMultiplicity(result, (MultiplicityElement)property);
                    this.appendDefault(result, property);
                }
            }
            return result.toString();
        }

        public boolean isAffectingFeature(EStructuralFeature feature) {
            return AFFECTING.contains(feature);
        }

        public List getAdditionalReferencedElements(EObject object) {
            ValueSpecification lower;
            Property property = this.asProperty(object);
            LinkedList<Object> result = new LinkedList<Object>();
            result.add(property);
            ValueSpecification upper = property.getUpperValue();
            if (upper != null) {
                result.add(upper);
            }
            if ((lower = property.getLowerValue()) != null) {
                result.add(lower);
            }
            if (property.getType() != null) {
                result.add(property.getType());
            }
            return result;
        }
    }
}

