/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.csd.edit.parts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.draw2d.DefaultSizeOvalAnchorableFigure;
import org.eclipse.uml2.diagram.common.editparts.PrimaryShapeEditPart;
import org.eclipse.uml2.diagram.common.editpolicies.UpdateDescriptionEditPolicy;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterLinkDescriptor;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterNodeDescriptor;
import org.eclipse.uml2.diagram.csd.edit.parts.CollaborationUseName2EditPart;
import org.eclipse.uml2.diagram.csd.edit.policies.CollaborationUse2ItemSemanticEditPolicy;
import org.eclipse.uml2.diagram.csd.part.UMLDiagramUpdateCommand;
import org.eclipse.uml2.diagram.csd.part.UMLDiagramUpdater;
import org.eclipse.uml2.diagram.csd.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollaborationUse2EditPart
extends ShapeNodeEditPart
implements PrimaryShapeEditPart {
    public static final int VISUAL_ID = 3002;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private LinkTargetListener myLinkTargetListener;

    public CollaborationUse2EditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        if (UMLVisualIDRegistry.isShortcutDescendant(this.getNotationView())) {
            this.installEditPolicy(UpdateDescriptionEditPolicy.ROLE, (EditPolicy)new UpdateDescriptionEditPolicy(UMLDiagramUpdater.TYPED_ADAPTER, true));
        }
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CollaborationUse2ItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        CollaborationUseFigure figure = new CollaborationUseFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public CollaborationUseFigure getPrimaryShape() {
        return (CollaborationUseFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof CollaborationUseName2EditPart) {
            ((CollaborationUseName2EditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureCollaborationUseFigure_name());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return super.getContentPaneFor(editPart);
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeOvalAnchorableFigure result = new DefaultSizeOvalAnchorableFigure(this.getMapMode().DPtoLP(100), this.getMapMode().DPtoLP(40));
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5002));
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        this.handleTypeLinkModification(event);
    }

    private DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    private LinkTargetListener getLinkTargetListener() {
        if (this.myLinkTargetListener == null) {
            this.myLinkTargetListener = new LinkTargetListener();
        }
        return this.myLinkTargetListener;
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        for (IUpdaterNodeDescriptor iUpdaterNodeDescriptor : this.getCollaborationUse_3002ContainedLinks()) {
            EObject nextLink = iUpdaterNodeDescriptor.getModelElement();
            if (nextLink == null) continue;
            switch (iUpdaterNodeDescriptor.getVisualID()) {
                case 4006: {
                    this.getLinkTargetListener().addReferenceListener(nextLink, (EStructuralFeature)UMLPackage.eINSTANCE.getDependency_Supplier());
                    break;
                }
            }
        }
    }

    private List<IUpdaterLinkDescriptor> getCollaborationUse_3002ContainedLinks() {
        return UMLDiagramUpdater.getCollaborationUse_3002ContainedLinks(this.getNotationView());
    }

    protected void removeSemanticListeners() {
        super.removeSemanticListeners();
        this.getLinkTargetListener().dispose();
    }

    private void handleTypeLinkModification(Notification event) {
        if (event.getFeature() == UMLPackage.eINSTANCE.getCollaborationUse_RoleBinding()) {
            block0 : switch (event.getEventType()) {
                case 3: {
                    Object link = event.getNewValue();
                    if (link instanceof Dependency) {
                        this.getLinkTargetListener().addReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getDependency_Supplier());
                    }
                    if (!(link instanceof Dependency)) break;
                    this.refreshDiagram();
                    break;
                }
                case 4: {
                    Object link = event.getOldValue();
                    if (link instanceof Dependency) {
                        this.getLinkTargetListener().removeReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getDependency_Supplier());
                    }
                    if (!(link instanceof Dependency)) break;
                    this.refreshDiagram();
                    break;
                }
                case 5: {
                    List links = (List)event.getNewValue();
                    for (Object link : links) {
                        if (!(link instanceof Dependency)) continue;
                        this.getLinkTargetListener().addReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getDependency_Supplier());
                    }
                    for (Object link : links) {
                        if (!(link instanceof Dependency)) continue;
                        this.refreshDiagram();
                        break block0;
                    }
                    break;
                }
                case 6: {
                    List links = (List)event.getOldValue();
                    for (Object link : links) {
                        if (!(link instanceof Dependency)) continue;
                        this.getLinkTargetListener().removeReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getDependency_Supplier());
                    }
                    for (Object link : links) {
                        if (!(link instanceof Dependency)) continue;
                        this.refreshDiagram();
                        break block0;
                    }
                    break;
                }
            }
        }
    }

    public void refreshDiagram() {
        UMLDiagramUpdateCommand.performCanonicalUpdate(this.getDiagramView().getElement());
    }

    public class CollaborationUseFigure
    extends Ellipse {
        private int myXMargin;
        private int myYMargin;
        private Label fFigureCollaborationUseFigure_name;
        private boolean myUseLocalCoordinates = false;

        public void paintFigure(Graphics graphics) {
            double sin45;
            Rectangle r = this.getBounds().getCopy();
            double a = r.width / 2;
            double b = r.height / 2;
            double cos45 = sin45 = Math.sqrt(2.0) / 2.0;
            double diagx = a * sin45;
            double diagy = b * cos45;
            int newxmargin = (int)(a - diagx);
            int newymargin = (int)(b - diagy);
            if (newxmargin != this.myXMargin || newymargin != this.myYMargin) {
                this.myXMargin = newxmargin;
                this.myYMargin = newymargin;
                this.setBorder((Border)new MarginBorder(this.myYMargin, this.myXMargin, this.myYMargin, this.myXMargin));
            }
            super.paintFigure(graphics);
        }

        public CollaborationUseFigure() {
            this.setLineStyle(2);
            this.createContents();
        }

        private void createContents() {
            this.fFigureCollaborationUseFigure_name = new Label();
            this.fFigureCollaborationUseFigure_name.setText("");
            this.add((IFigure)this.fFigureCollaborationUseFigure_name);
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        public Label getFigureCollaborationUseFigure_name() {
            return this.fFigureCollaborationUseFigure_name;
        }
    }

    private class LinkTargetListener
    implements NotificationListener {
        Map<EObject, Set<EStructuralFeature>> myNotifiers = new HashMap<EObject, Set<EStructuralFeature>>();

        private LinkTargetListener() {
        }

        private void added(EObject link, EStructuralFeature feature) {
            if (!this.myNotifiers.containsKey(link)) {
                this.myNotifiers.put(link, new HashSet());
            }
            this.myNotifiers.get(link).add(feature);
        }

        private void removed(EObject link, EStructuralFeature feature) {
            if (!this.myNotifiers.containsKey(link)) {
                return;
            }
            this.myNotifiers.get(link).remove(feature);
        }

        public void dispose() {
            Set<Map.Entry<EObject, Set<EStructuralFeature>>> entrySet = this.myNotifiers.entrySet();
            for (Map.Entry<EObject, Set<EStructuralFeature>> entry : entrySet) {
                for (EStructuralFeature feature : entry.getValue()) {
                    CollaborationUse2EditPart.this.getDiagramEventBroker().removeNotificationListener(entry.getKey(), (Object)feature, (NotificationListener)this);
                }
            }
        }

        private void removeReferenceListener(EObject link, EStructuralFeature feature) {
            CollaborationUse2EditPart.this.getDiagramEventBroker().removeNotificationListener(link, (Object)feature, (NotificationListener)this);
            this.removed(link, feature);
        }

        private void addReferenceListener(EObject link, EStructuralFeature feature) {
            CollaborationUse2EditPart.this.getDiagramEventBroker().addNotificationListener(link, feature, (NotificationListener)this);
            this.added(link, feature);
        }

        public void notifyChanged(Notification event) {
            if (event.getFeature() == UMLPackage.eINSTANCE.getDependency_Supplier()) {
                CollaborationUse2EditPart.this.refreshDiagram();
                return;
            }
        }
    }
}

