/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.editor.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.uml2.common.edit.domain.UML2AdapterFactoryEditingDomain;
import org.eclipse.uml2.common.edit.provider.IItemQualifiedTextProvider;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.edit.providers.ElementItemProvider;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.eclipse.uml2.uml.edit.providers.UMLReflectiveItemProviderAdapterFactory;
import org.eclipse.uml2.uml.edit.providers.UMLResourceItemProviderAdapterFactory;
import org.eclipse.uml2.uml.editor.UMLEditorPlugin;
import org.eclipse.uml2.uml.resource.CMOF2UMLExtendedMetaData;
import org.eclipse.uml2.uml.resource.CMOF2UMLResource;
import org.eclipse.uml2.uml.resource.UML22UMLExtendedMetaData;
import org.eclipse.uml2.uml.resource.UML22UMLResource;
import org.eclipse.uml2.uml.resource.XMI2UMLExtendedMetaData;
import org.eclipse.uml2.uml.resource.XMI2UMLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected TreeViewer selectionViewer;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == UMLEditor.this.contentOutlinePage) {
                    UMLEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)UMLEditor.this);
                    UMLEditor.this.setCurrentViewer((Viewer)UMLEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == UMLEditor.this.propertySheetPage) {
                    UMLEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)UMLEditor.this);
                    UMLEditor.this.handleActivate();
                }
            } else if (p == UMLEditor.this) {
                UMLEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = UMLEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            UMLEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            UMLEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!UMLEditor.this.updateProblemIndication) return;
                        UMLEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                UMLEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).UMLEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        Resource resource;
                        if (delta.getResource().getType() == 1 && (delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createURI((String)delta.getFullPath().toString()), false)) != null) {
                            if (delta.getKind() == 2) {
                                this.removedResources.add(resource);
                            } else if (!(this).UMLEditor.this.savedResources.remove(resource)) {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    UMLEditor.this.removedResources.addAll(visitor.getRemovedResources());
                    if (!UMLEditor.this.isDirty()) {
                        UMLEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                UMLEditor.this.getSite().getPage().closeEditor((IEditorPart)UMLEditor.this, false);
                                UMLEditor.this.dispose();
                            }
                        });
                    }
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    UMLEditor.this.changedResources.addAll(visitor.getChangedResources());
                    if (UMLEditor.this.getSite().getPage().getActiveEditor() == UMLEditor.this) {
                        UMLEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                UMLEditor.this.handleActivate();
                            }
                        });
                    }
                }
            }
            catch (CoreException exception) {
                UMLEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                this.dispose();
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.uml2.uml.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    UMLEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        UMLEditorPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)UMLEditor.getString("_UI_FileConflict_label"), (String)UMLEditor.getString("_WARN_FileConflict"));
    }

    public UMLEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomain() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new UMLResourceItemProviderAdapterFactory());
        factories.add(new UMLItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new UMLReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack(){

            protected void handleError(Exception exception) {
                super.handleError(exception);
                BasicDiagnostic diagnostic = new BasicDiagnostic(UMLEditorPlugin.INSTANCE.getSymbolicName(), 0, exception.getLocalizedMessage(), null);
                diagnostic.add(BasicDiagnostic.toDiagnostic((Throwable)exception));
                DiagnosticDialog.openProblem((Shell)UMLEditor.this.getSite().getShell(), null, (String)CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Diagnostic)diagnostic);
            }
        };
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                UMLEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        UMLEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            UMLEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        if ((this).UMLEditor.this.propertySheetPage != null && !(this).UMLEditor.this.propertySheetPage.getControl().isDisposed()) {
                            (this).UMLEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new UML2AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (UMLEditor.this.currentViewer != null) {
                        UMLEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        UMLEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void createModelGen() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public void createModel() {
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        Map contentTypeToFactoryMap = resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap();
        contentTypeToFactoryMap.put("org.eclipse.uml2", UML22UMLResource.Factory.INSTANCE);
        contentTypeToFactoryMap.put("org.omg.uml_2_1_1", XMI2UMLResource.Factory.INSTANCE);
        contentTypeToFactoryMap.put("org.omg.uml_2_1_1", XMI2UMLResource.Factory.INSTANCE);
        contentTypeToFactoryMap.put("org.omg.uml_2_1", XMI2UMLResource.Factory.INSTANCE);
        contentTypeToFactoryMap.put("org.omg.mof.cmof", CMOF2UMLResource.Factory.INSTANCE);
        Map uriMap = resourceSet.getURIConverter().getURIMap();
        uriMap.putAll(UML22UMLExtendedMetaData.getURIMap());
        uriMap.putAll(XMI2UMLExtendedMetaData.getURIMap());
        uriMap.putAll(CMOF2UMLExtendedMetaData.getURIMap());
        this.createModelGen();
        boolean saveNeeded = false;
        HashMap<Resource, URI> resourceToURIMap = new HashMap<Resource, URI>();
        EList resources = resourceSet.getResources();
        int i = 0;
        while (i < resources.size()) {
            Resource resource = (Resource)resources.get(i);
            URI uri = resource.getURI();
            if (uriMap.containsKey(uri)) {
                uri = (URI)uriMap.get(uri);
            } else if ("uml2".equals(uri.fileExtension())) {
                uri = uri.trimFileExtension().appendFileExtension("uml");
                if (i == 0) {
                    this.setInputWithNotify((IEditorInput)new URIEditorInput(uri));
                    this.setPartName(uri.lastSegment());
                    saveNeeded = true;
                }
                EcoreUtil.resolveAll((Resource)resource);
            }
            resourceToURIMap.put(resource, uri);
            ++i;
        }
        for (Map.Entry entry : resourceToURIMap.entrySet()) {
            ((Resource)entry.getKey()).setURI((URI)entry.getValue());
        }
        if (saveNeeded) {
            NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
            this.doSave((IProgressMonitor)progressMonitor);
        }
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.uml2.uml.editor", 0, UMLEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.uml2.uml.editor", 0, UMLEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void createPages() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            Tree tree = new Tree(this.getContainer(), 2);
            this.selectionViewer = new TreeViewer(tree);
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.FontAndColorProvider((AdapterFactory)this.adapterFactory, (Viewer)this.selectionViewer));
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)tree);
            this.setPageText(pageIndex, UMLEditor.getString("_UI_SelectionPage_label"));
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    UMLEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    UMLEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                UMLEditor.this.updateProblemIndication();
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, UMLEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    UMLEditor.this.contentOutlineViewer = this.getTreeViewer();
                    UMLEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    UMLEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)UMLEditor.this.adapterFactory));
                    UMLEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.FontAndColorProvider((AdapterFactory)UMLEditor.this.adapterFactory, (Viewer)UMLEditor.this.contentOutlineViewer));
                    UMLEditor.this.contentOutlineViewer.setInput((Object)UMLEditor.this.editingDomain.getResourceSet());
                    UMLEditor.this.createContextMenuFor((StructuredViewer)UMLEditor.this.contentOutlineViewer);
                    if (!UMLEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        UMLEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(UMLEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    UMLEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    UMLEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    UMLEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPageGen() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

                public void setSelectionToViewer(List<?> selection) {
                    UMLEditor.this.setSelectionToViewer(selection);
                    UMLEditor.this.setFocus();
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    UMLEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

                public void setSelectionToViewer(List<?> selection) {
                    UMLEditor.this.setSelectionToViewer(selection);
                    UMLEditor.this.setFocus();
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    UMLEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new UMLAdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.selectionViewer != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList selectionList = new ArrayList();
            selectionList.add(selectedElement);
            while (selectedElements.hasNext()) {
                selectionList.add(selectedElements.next());
            }
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : UMLEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !UMLEditor.this.isPersisted(resource) || UMLEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        UMLEditor.this.savedResources.add(resource);
                        resource.save(saveOptions);
                    }
                    catch (Exception exception) {
                        UMLEditor.this.resourceToDiagnosticMap.put(resource, UMLEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            UMLEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void copyResource(ResourceSet resourceSet, Resource resource, URI uri) {
        String fileExtension = uri.fileExtension();
        Resource newResource = resourceSet.createResource(uri, "xmi".equals(fileExtension) ? "org.omg.uml_2_1_1" : ("cmof".equals(fileExtension) ? "org.omg.mof.cmof" : null));
        EList newContents = newResource.getContents();
        Iterator contents = resource.getContents().iterator();
        while (contents.hasNext()) {
            EObject eObject = (EObject)contents.next();
            contents.remove();
            newContents.add((Object)eObject);
        }
        EList resources = resourceSet.getResources();
        int index = resources.indexOf((Object)resource);
        resources.remove(index);
        resources.move(index, (Object)newResource);
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            String newFileExtension;
            URI newURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            EList resources = resourceSet.getResources();
            Resource resource = (Resource)resources.get(0);
            URI uri = resource.getURI();
            String fileExtension = uri.fileExtension();
            if (!UML2Util.safeEquals((Object)fileExtension, (Object)(newFileExtension = newURI.fileExtension()))) {
                this.copyResource(resourceSet, resource, newURI);
                if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)this.getTitle(), (String)UMLEditorPlugin.INSTANCE.getString("_UI_Save_All_Resources_As", new Object[]{fileExtension, newFileExtension}))) {
                    EcoreUtil.resolveAll((ResourceSet)resourceSet);
                    int i = 1;
                    while (i < resources.size()) {
                        resource = (Resource)resources.get(i);
                        uri = resource.getURI();
                        if (UML2Util.safeEquals((Object)uri.fileExtension(), (Object)fileExtension) && (!resource.getContents().isEmpty() || this.isPersisted(resource)) && !this.editingDomain.isReadOnly(resource)) {
                            this.copyResource(resourceSet, resource, uri.trimFileExtension().appendFileExtension(newFileExtension));
                        }
                        ++i;
                    }
                }
            }
            this.doSaveAs(newURI, (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.isSubtypeOf("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.setSelectionToViewer((Collection)Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException exception) {
            UMLEditorPlugin.INSTANCE.log((Object)exception);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(UMLEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(UMLEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(UMLEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return UMLEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return UMLEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void disposeGen() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    public void dispose() {
        this.disposeGen();
        for (Resource resource : this.editingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
    }

    protected boolean showOutlineView() {
        return false;
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }

    protected static class UMLAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        protected UMLAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        protected IPropertySource createPropertySource(Object object, IItemPropertySource itemPropertySource) {
            return new UMLPropertySource(object, itemPropertySource);
        }
    }

    protected static class UMLPropertyDescriptor
    extends PropertyDescriptor {
        protected UMLPropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
            super(object, itemPropertyDescriptor);
        }

        protected ILabelProvider getEditLabelProvider() {
            final ILabelProvider editLabelProvider = super.getEditLabelProvider();
            return new LabelProvider(){

                public String getText(Object object) {
                    return UMLPropertyDescriptor.this.itemPropertyDescriptor instanceof IItemQualifiedTextProvider ? ((IItemQualifiedTextProvider)UMLPropertyDescriptor.this.itemPropertyDescriptor).getQualifiedText(object) : editLabelProvider.getText(object);
                }

                public Image getImage(Object object) {
                    return editLabelProvider.getImage(object);
                }
            };
        }
    }

    protected static class UMLPropertySource
    extends PropertySource {
        protected List<IItemPropertyDescriptor> stereotypeApplicationItemPropertyDescriptors = null;

        protected UMLPropertySource(Object object, IItemPropertySource itemPropertySource) {
            super(object, itemPropertySource);
        }

        protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
            return new UMLPropertyDescriptor(this.object, itemPropertyDescriptor);
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            ArrayList<IPropertyDescriptor> propertyDescriptors = new ArrayList<IPropertyDescriptor>();
            List itemPropertyDescriptors = this.itemPropertySource.getPropertyDescriptors(this.object);
            if (itemPropertyDescriptors != null) {
                for (IItemPropertyDescriptor itemPropertyDescriptor : itemPropertyDescriptors) {
                    propertyDescriptors.add(this.createPropertyDescriptor(itemPropertyDescriptor));
                }
            }
            if (this.itemPropertySource instanceof ElementItemProvider) {
                ElementItemProvider elementItemProvider = (ElementItemProvider)this.itemPropertySource;
                this.stereotypeApplicationItemPropertyDescriptors = elementItemProvider.getStereotypeApplicationPropertyDescriptors(this.object);
                if (this.stereotypeApplicationItemPropertyDescriptors != null) {
                    for (IItemPropertyDescriptor itemPropertyDescriptor : this.stereotypeApplicationItemPropertyDescriptors) {
                        propertyDescriptors.add(this.createPropertyDescriptor(itemPropertyDescriptor));
                    }
                }
            }
            return propertyDescriptors.toArray(new IPropertyDescriptor[propertyDescriptors.size()]);
        }

        protected IItemPropertyDescriptor getItemPropertyDescriptor(Object propertyId) {
            IItemPropertyDescriptor itemPropertyDescriptor = this.itemPropertySource.getPropertyDescriptor(this.object, propertyId);
            return itemPropertyDescriptor == null && this.itemPropertySource instanceof ElementItemProvider ? ((ElementItemProvider)this.itemPropertySource).getStereotypeApplicationPropertyDescriptor(this.object, propertyId) : itemPropertyDescriptor;
        }

        public Object getPropertyValue(Object propertyId) {
            return this.getItemPropertyDescriptor(propertyId).getPropertyValue(this.object);
        }

        public boolean isPropertySet(Object propertyId) {
            return this.getItemPropertyDescriptor(propertyId).isPropertySet(this.object);
        }

        public void resetPropertyValue(Object propertyId) {
            this.getItemPropertyDescriptor(propertyId).resetPropertyValue(this.object);
        }

        public void setPropertyValue(Object propertyId, Object value) {
            this.getItemPropertyDescriptor(propertyId).setPropertyValue(this.object, value);
        }
    }
}

