/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ExpansionKind implements Enumerator
{
    PARALLEL_LITERAL(0, "parallel", "parallel"),
    ITERATIVE_LITERAL(1, "iterative", "iterative"),
    STREAM_LITERAL(2, "stream", "stream");

    public static final int PARALLEL = 0;
    public static final int ITERATIVE = 1;
    public static final int STREAM = 2;
    private static final ExpansionKind[] VALUES_ARRAY;
    public static final List<ExpansionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExpansionKind[]{PARALLEL_LITERAL, ITERATIVE_LITERAL, STREAM_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExpansionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExpansionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExpansionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExpansionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExpansionKind get(int value) {
        switch (value) {
            case 0: {
                return PARALLEL_LITERAL;
            }
            case 1: {
                return ITERATIVE_LITERAL;
            }
            case 2: {
                return STREAM_LITERAL;
            }
        }
        return null;
    }

    private ExpansionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

