/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.internal.operations.ValueSpecificationOperations;

public class LiteralStringOperations
extends ValueSpecificationOperations {
    protected LiteralStringOperations() {
    }

    public static int integerValue(LiteralString literalString) {
        try {
            return Integer.parseInt(literalString.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnsupportedOperationException();
        }
    }

    public static int unlimitedValue(LiteralString literalString) {
        try {
            String value = literalString.getValue();
            return "*".equals(value) ? -1 : Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnsupportedOperationException();
        }
    }

    public static boolean isComputable(LiteralString literalString) {
        return true;
    }

    public static String stringValue(LiteralString literalString) {
        return literalString.getValue();
    }
}

