/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.examples.extlibrary.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.BookCategory;
import org.eclipse.emf.examples.extlibrary.BookOnTape;
import org.eclipse.emf.examples.extlibrary.Borrower;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Employee;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Person;
import org.eclipse.emf.examples.extlibrary.VideoCassette;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.examples.extlibrary.impl.BookImpl;
import org.eclipse.emf.examples.extlibrary.impl.BookOnTapeImpl;
import org.eclipse.emf.examples.extlibrary.impl.BorrowerImpl;
import org.eclipse.emf.examples.extlibrary.impl.EmployeeImpl;
import org.eclipse.emf.examples.extlibrary.impl.LibraryImpl;
import org.eclipse.emf.examples.extlibrary.impl.PersonImpl;
import org.eclipse.emf.examples.extlibrary.impl.VideoCassetteImpl;
import org.eclipse.emf.examples.extlibrary.impl.WriterImpl;

public class EXTLibraryFactoryImpl
extends EFactoryImpl
implements EXTLibraryFactory {
    public static EXTLibraryFactory init() {
        try {
            EXTLibraryFactory theEXTLibraryFactory = (EXTLibraryFactory)EPackage.Registry.INSTANCE.getEFactory("http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0");
            if (theEXTLibraryFactory != null) {
                return theEXTLibraryFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new EXTLibraryFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createBook();
            }
            case 1: {
                return this.createLibrary();
            }
            case 2: {
                return this.createWriter();
            }
            case 8: {
                return this.createBookOnTape();
            }
            case 9: {
                return this.createVideoCassette();
            }
            case 10: {
                return this.createBorrower();
            }
            case 11: {
                return this.createPerson();
            }
            case 12: {
                return this.createEmployee();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 14: {
                return this.createBookCategoryFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 14: {
                return this.convertBookCategoryToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Book createBook() {
        BookImpl book = new BookImpl();
        return book;
    }

    public Library createLibrary() {
        LibraryImpl library = new LibraryImpl();
        return library;
    }

    public Writer createWriter() {
        WriterImpl writer = new WriterImpl();
        return writer;
    }

    public BookOnTape createBookOnTape() {
        BookOnTapeImpl bookOnTape = new BookOnTapeImpl();
        return bookOnTape;
    }

    public VideoCassette createVideoCassette() {
        VideoCassetteImpl videoCassette = new VideoCassetteImpl();
        return videoCassette;
    }

    public Borrower createBorrower() {
        BorrowerImpl borrower = new BorrowerImpl();
        return borrower;
    }

    public Person createPerson() {
        PersonImpl person = new PersonImpl();
        return person;
    }

    public Employee createEmployee() {
        EmployeeImpl employee = new EmployeeImpl();
        return employee;
    }

    public BookCategory createBookCategoryFromString(EDataType eDataType, String initialValue) {
        BookCategory result = BookCategory.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertBookCategoryToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public EXTLibraryPackage getEXTLibraryPackage() {
        return (EXTLibraryPackage)this.getEPackage();
    }

    @Deprecated
    public static EXTLibraryPackage getPackage() {
        return EXTLibraryPackage.eINSTANCE;
    }
}

