/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JETSkeleton {
    protected final String NL = System.getProperties().getProperty("line.separator");
    protected final String SKELETON_COMPILATION_UNIT = "public class CLASS" + this.NL + "{" + this.NL + "  public String generate(Object argument)" + this.NL + "  {" + this.NL + "    return \"\";" + this.NL + "  }" + this.NL + "}" + this.NL;
    protected final String STATIC_NL_DECLARATION = "  protected static String nl;" + this.NL;
    protected final String CREATE_METHOD_DECLARATION_HEAD = "  public static synchronized ";
    protected final String CREATE_METHOD_DECLARATION_MIDDLE = " create(String lineSeparator)" + this.NL + "  {" + this.NL + "    nl = lineSeparator;" + this.NL + "    ";
    protected final String CREATE_METHOD_DECLARATION_MIDDLE2 = " result = new ";
    protected final String CREATE_METHOD_DECLARATION_TAIL = "();" + this.NL + "    nl = null;" + this.NL + "    return result;" + this.NL + "  }" + this.NL + this.NL;
    protected final String NL_DECLARATION = "  public final String NL = nl == null ? (";
    protected final String NL_DECLARATION_TAIL = ") : nl;" + this.NL;
    protected final String STRING_BUFFER_DECLARATION = "    final StringBuffer stringBuffer = new StringBuffer();" + this.NL;
    protected final String STRING_BUFFER_RETURN = "    return stringBuffer.toString();" + this.NL;
    protected DOMFactory jdomFactory = new DOMFactory();
    protected IDOMCompilationUnit compilationUnit = this.jdomFactory.createCompilationUnit(this.SKELETON_COMPILATION_UNIT, "CLASS");
    protected String nlString = "System.getProperties().getProperty(\"line.separator\")";
    protected static final Pattern NL_PATTERN = Pattern.compile("([\\n][\\r]?|[\\r][\\n]?)", 8);

    public String getCompilationUnitContents() {
        return this.compilationUnit.getContents();
    }

    public IDOMCompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public void setCompilationUnitContents(String contents) {
        this.compilationUnit = this.jdomFactory.createCompilationUnit(this.convertLineFeed(contents), "CLASS");
    }

    public String getNLString() {
        return this.nlString;
    }

    public void setNLString(String nlString) {
        this.nlString = nlString;
    }

    public String getPackageName() {
        IDOMNode node = this.compilationUnit.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 2) {
                return node.getName();
            }
            node = node.getNextNode();
        }
        return "";
    }

    public void setPackageName(String packageName) {
        IDOMNode node = this.compilationUnit.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 2) {
                node.setName(packageName);
                return;
            }
            node = node.getNextNode();
        }
        this.compilationUnit.getFirstChild().insertSibling((IDOMNode)this.jdomFactory.createPackage("package " + packageName + ";" + this.NL + this.NL));
    }

    public void setConstants(List<String> constants) {
        IDOMNode node = this.compilationUnit.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                String name = node.getName();
                IDOMNode insertionNode = node.getFirstChild();
                insertionNode.insertSibling((IDOMNode)this.jdomFactory.createField(this.STATIC_NL_DECLARATION));
                insertionNode.insertSibling((IDOMNode)this.jdomFactory.createMethod("  public static synchronized " + name + this.CREATE_METHOD_DECLARATION_MIDDLE + name + " result = new " + name + this.CREATE_METHOD_DECLARATION_TAIL));
                insertionNode.insertSibling((IDOMNode)this.jdomFactory.createField("  public final String NL = nl == null ? (" + this.getNLString() + this.NL_DECLARATION_TAIL));
                Iterator<String> i = constants.iterator();
                while (i.hasNext()) {
                    String constant = "  " + i.next() + this.NL;
                    if (!i.hasNext()) {
                        constant = String.valueOf(constant) + this.NL;
                    }
                    insertionNode.insertSibling((IDOMNode)this.jdomFactory.createField(constant));
                }
                break;
            }
            node = node.getNextNode();
        }
    }

    public void setBody(List<String> lines) {
        IDOMMethod method = this.getLastMethod();
        if (method != null) {
            StringBuffer body = new StringBuffer();
            body.append(String.valueOf(this.NL) + "  {" + this.NL);
            body.append(this.STRING_BUFFER_DECLARATION);
            for (String line : lines) {
                body.append("    ");
                body.append(this.convertLineFeed(line));
                body.append(this.NL);
            }
            body.append(this.STRING_BUFFER_RETURN);
            body.append("  }" + this.NL);
            method.setBody(body.toString());
        }
    }

    public String convertLineFeed(String value) {
        String nl;
        Matcher matcher = NL_PATTERN.matcher(value);
        if (matcher.find() && !this.NL.equals(nl = matcher.group(1))) {
            return value.replaceAll(nl, this.NL);
        }
        return value;
    }

    public String getMethodName() {
        IDOMMethod method = this.getLastMethod();
        if (method != null) {
            return method.getName();
        }
        return "";
    }

    public void addImports(String importList) {
        IDOMNode node = this.compilationUnit.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                StringTokenizer stringTokenizer = new StringTokenizer(importList, " \t\n\r");
                while (stringTokenizer.hasMoreTokens()) {
                    IDOMImport imports;
                    String token = stringTokenizer.nextToken();
                    String newImport = "import " + token + ";" + this.NL;
                    if (!stringTokenizer.hasMoreTokens()) {
                        newImport = String.valueOf(newImport) + this.NL;
                    }
                    if ((imports = this.jdomFactory.createImport(newImport)) == null) continue;
                    node.insertSibling((IDOMNode)imports);
                }
                return;
            }
            node = node.getNextNode();
        }
    }

    public String getClassName() {
        IDOMNode node = this.compilationUnit.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                return node.getName();
            }
            node = node.getNextNode();
        }
        return null;
    }

    public void setClassName(String className) {
        IDOMNode node = this.compilationUnit.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                node.setName(className);
            }
            node = node.getNextNode();
        }
    }

    protected IDOMMethod getLastMethod() {
        IDOMMethod method = null;
        IDOMNode node = this.compilationUnit.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                IDOMNode child = node.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 6) {
                        method = (IDOMMethod)child;
                    }
                    child = child.getNextNode();
                }
            }
            node = node.getNextNode();
        }
        return method;
    }
}

