package org.eclipse.emf.codegen.ecore.templates.edit;

import java.util.*;
import org.eclipse.emf.codegen.ecore.genmodel.*;

public class ItemProviderAdapterFactory
{
  protected static String nl;
  public static synchronized ItemProviderAdapterFactory create(String lineSeparator)
  {
    nl = lineSeparator;
    ItemProviderAdapterFactory result = new ItemProviderAdapterFactory();
    nl = null;
    return result;
  }

  public final String NL = nl == null ? (System.getProperties().getProperty("line.separator")) : nl;
  protected final String TEXT_1 = "";
  protected final String TEXT_2 = "/**";
  protected final String TEXT_3 = NL + " * ";
  protected final String TEXT_4 = NL + " */" + NL + "package ";
  protected final String TEXT_5 = ";" + NL;
  protected final String TEXT_6 = NL + NL + "/**" + NL + " * This is the factory that is used to provide the interfaces needed to support Viewers." + NL + " * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}." + NL + " * The adapters also support Eclipse property sheets." + NL + " * Note that most of the adapters are shared among multiple instances." + NL + " * <!-- begin-user-doc -->" + NL + " * <!-- end-user-doc -->" + NL + " * @generated" + NL + " */" + NL + "public class ";
  protected final String TEXT_7 = " extends ";
  protected final String TEXT_8 = " implements ComposeableAdapterFactory, IChangeNotifier";
  protected final String TEXT_9 = ", ";
  protected final String TEXT_10 = ", ";
  protected final String TEXT_11 = NL + "{";
  protected final String TEXT_12 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_13 = " copyright = ";
  protected final String TEXT_14 = ";";
  protected final String TEXT_15 = NL;
  protected final String TEXT_16 = NL + "\t/**" + NL + "\t * This keeps track of the root adapter factory that delegates to this adapter factory." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected ComposedAdapterFactory parentAdapterFactory;" + NL + "" + NL + "\t/**" + NL + "\t * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected IChangeNotifier changeNotifier = new ChangeNotifier();" + NL;
  protected final String TEXT_17 = NL + "\t/**" + NL + "\t * This keeps track of all the item providers created, so that they can be {@link #dispose disposed}." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected ";
  protected final String TEXT_18 = " disposable = new Disposable();" + NL;
  protected final String TEXT_19 = NL + "\t/**" + NL + "\t * This helps manage the child creation extenders." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected ";
  protected final String TEXT_20 = " childCreationExtenderManager = new ";
  protected final String TEXT_21 = "(";
  protected final String TEXT_22 = ".INSTANCE, ";
  protected final String TEXT_23 = ".eNS_URI);" + NL;
  protected final String TEXT_24 = NL + "\t/**" + NL + "\t * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected ";
  protected final String TEXT_25 = " supportedTypes = new ";
  protected final String TEXT_26 = "();" + NL + "" + NL + "\t/**" + NL + "\t * This constructs an instance." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic ";
  protected final String TEXT_27 = "()" + NL + "\t{";
  protected final String TEXT_28 = NL + "\t\tsupportedTypes.add(";
  protected final String TEXT_29 = ".class);";
  protected final String TEXT_30 = NL + "\t}" + NL;
  protected final String TEXT_31 = NL + "\t/**" + NL + "\t * This keeps track of the factory to which to delegate adapter creation for objects from that package." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected ";
  protected final String TEXT_32 = " ";
  protected final String TEXT_33 = " = null;" + NL + "" + NL + "\t/**" + NL + "\t * This determines the delegate factory for the package." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected ";
  protected final String TEXT_34 = " get";
  protected final String TEXT_35 = "()" + NL + "\t{" + NL + "\t\tif (";
  protected final String TEXT_36 = " == null)" + NL + "\t\t{" + NL + "\t\t\t";
  protected final String TEXT_37 = " rootAdapterFactory = getRootAdapterFactory();" + NL + "\t\t\tif (rootAdapterFactory instanceof ComposedAdapterFactory)" + NL + "\t\t\t{" + NL + "\t\t\t\t";
  protected final String TEXT_38 = " delegateAdapterFactory =" + NL + "\t\t\t\t\t((ComposedAdapterFactory)rootAdapterFactory).getFactoryForType(";
  protected final String TEXT_39 = ".getPackage());" + NL + "\t\t\t\tif (delegateAdapterFactory instanceof ";
  protected final String TEXT_40 = ")" + NL + "\t\t\t\t{" + NL + "\t\t\t\t\t";
  protected final String TEXT_41 = " = (";
  protected final String TEXT_42 = ")delegateAdapterFactory;" + NL + "\t\t\t\t}" + NL + "\t\t\t}" + NL + "\t\t}" + NL + "\t\treturn ";
  protected final String TEXT_43 = ";" + NL + "\t}" + NL;
  protected final String TEXT_44 = NL + "\t/**" + NL + "\t * This keeps track of the one adapter used for all {@link ";
  protected final String TEXT_45 = "} instances." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected ";
  protected final String TEXT_46 = " ";
  protected final String TEXT_47 = "ItemProvider;" + NL + "" + NL + "\t/**" + NL + "\t * This creates an adapter for a {@link ";
  protected final String TEXT_48 = "}." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */";
  protected final String TEXT_49 = NL + "\t@Override";
  protected final String TEXT_50 = NL + "\tpublic Adapter create";
  protected final String TEXT_51 = "Adapter()" + NL + "\t{" + NL + "\t\tif (";
  protected final String TEXT_52 = "ItemProvider == null)" + NL + "\t\t{" + NL + "\t\t\t";
  protected final String TEXT_53 = "ItemProvider = new ";
  protected final String TEXT_54 = "(this);" + NL + "\t\t}" + NL + "" + NL + "\t\treturn ";
  protected final String TEXT_55 = "ItemProvider;" + NL + "\t}" + NL;
  protected final String TEXT_56 = NL + "\t/**" + NL + "\t * This creates an adapter for a {@link ";
  protected final String TEXT_57 = "}." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */";
  protected final String TEXT_58 = NL + "\t@Override";
  protected final String TEXT_59 = NL + "\tpublic Adapter create";
  protected final String TEXT_60 = "Adapter()" + NL + "\t{" + NL + "\t\treturn new ";
  protected final String TEXT_61 = "(this);" + NL + "\t}" + NL;
  protected final String TEXT_62 = NL + "\t/**" + NL + "\t * ";
  protected final String TEXT_63 = " of ";
  protected final String TEXT_64 = NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic Adapter create";
  protected final String TEXT_65 = "Adapter()" + NL + "\t{" + NL + "\t\treturn" + NL + "\t\t\tget";
  protected final String TEXT_66 = "() == null ?" + NL + "\t\t\t\tnull :" + NL + "\t\t\t\tget";
  protected final String TEXT_67 = "().create";
  protected final String TEXT_68 = "Adapter();" + NL + "\t}" + NL;
  protected final String TEXT_69 = NL + "\t/**" + NL + "\t * This returns the root adapter factory that contains this factory." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic ComposeableAdapterFactory getRootAdapterFactory()" + NL + "\t{" + NL + "\t\treturn parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * This sets the composed adapter factory that contains this factory." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory)" + NL + "\t{" + NL + "\t\tthis.parentAdapterFactory = parentAdapterFactory;" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */";
  protected final String TEXT_70 = NL + "\t@Override";
  protected final String TEXT_71 = NL + "\tpublic boolean isFactoryForType(Object type)" + NL + "\t{" + NL + "\t\treturn supportedTypes.contains(type) || super.isFactoryForType(type);" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * This implementation substitutes the factory itself as the key for the adapter." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */";
  protected final String TEXT_72 = NL + "\t@Override";
  protected final String TEXT_73 = NL + "\tpublic Adapter adapt(Notifier notifier, Object type)" + NL + "\t{" + NL + "\t\treturn super.adapt(notifier, this);" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */";
  protected final String TEXT_74 = NL + "\t@Override";
  protected final String TEXT_75 = NL + "\tpublic Object adapt(Object object, Object type)" + NL + "\t{" + NL + "\t\tif (isFactoryForType(type))" + NL + "\t\t{" + NL + "\t\t\tObject adapter = super.adapt(object, type);" + NL + "\t\t\tif (!(type instanceof Class";
  protected final String TEXT_76 = "<?>";
  protected final String TEXT_77 = ") || ";
  protected final String TEXT_78 = ".isInstance((Class";
  protected final String TEXT_79 = "<?>";
  protected final String TEXT_80 = ")type, adapter)";
  protected final String TEXT_81 = "(((Class";
  protected final String TEXT_82 = "<?>";
  protected final String TEXT_83 = ")type).isInstance(adapter))";
  protected final String TEXT_84 = ")" + NL + "\t\t\t{" + NL + "\t\t\t\treturn adapter;" + NL + "\t\t\t}" + NL + "\t\t}" + NL + "" + NL + "\t\treturn null;" + NL + "\t}" + NL;
  protected final String TEXT_85 = NL + "\t/**" + NL + "\t * Associates an adapter with a notifier via the base implementation, then records it to ensure it will be disposed." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */";
  protected final String TEXT_86 = NL + "\t@Override";
  protected final String TEXT_87 = NL + "\tprotected void associate(Adapter adapter, Notifier target)" + NL + "\t{" + NL + "\t\tsuper.associate(adapter, target);" + NL + "\t\tif (adapter != null)" + NL + "\t\t{" + NL + "\t\t\tdisposable.add(adapter);" + NL + "\t\t}" + NL + "\t}" + NL;
  protected final String TEXT_88 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic ";
  protected final String TEXT_89 = " getChildCreationExtenders()" + NL + "\t{" + NL + "\t\treturn childCreationExtenderManager.getChildCreationExtenders();" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic ";
  protected final String TEXT_90 = " getNewChildDescriptors(Object object, ";
  protected final String TEXT_91 = " editingDomain)" + NL + "\t{" + NL + "\t\treturn childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic ";
  protected final String TEXT_92 = " getResourceLocator()" + NL + "\t{" + NL + "\t\treturn childCreationExtenderManager;" + NL + "\t}" + NL;
  protected final String TEXT_93 = NL + "\t/**" + NL + "\t * This adds a listener." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic void addListener(INotifyChangedListener notifyChangedListener)" + NL + "\t{" + NL + "\t\tchangeNotifier.addListener(notifyChangedListener);" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * This removes a listener." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic void removeListener(INotifyChangedListener notifyChangedListener)" + NL + "\t{" + NL + "\t\tchangeNotifier.removeListener(notifyChangedListener);" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic void fireNotifyChanged(Notification notification)" + NL + "\t{" + NL + "\t\tchangeNotifier.fireNotifyChanged(notification);" + NL + "" + NL + "\t\tif (parentAdapterFactory != null)" + NL + "\t\t{" + NL + "\t\t\tparentAdapterFactory.fireNotifyChanged(notification);" + NL + "\t\t}" + NL + "\t}" + NL;
  protected final String TEXT_94 = NL + "\t/**" + NL + "\t * This disposes all of the item providers created by this factory. " + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic void dispose()" + NL + "\t{";
  protected final String TEXT_95 = NL + "\t\tdisposable.dispose();";
  protected final String TEXT_96 = NL + "\t\tif (";
  protected final String TEXT_97 = "ItemProvider != null) ";
  protected final String TEXT_98 = "ItemProvider.dispose();";
  protected final String TEXT_99 = NL + "\t}" + NL;
  protected final String TEXT_100 = NL + "\t/**" + NL + "\t * A child creation extender for the {@link ";
  protected final String TEXT_101 = "}." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic static class ";
  protected final String TEXT_102 = " implements ";
  protected final String TEXT_103 = NL + "\t{" + NL + "\t\t/**" + NL + "\t\t * The switch for creating child descriptors specific to each extended class." + NL + "\t\t * <!-- begin-user-doc -->" + NL + "\t\t * <!-- end-user-doc -->" + NL + "\t\t * @generated" + NL + "\t\t */" + NL + "\t\tprotected static class CreationSwitch extends ";
  protected final String TEXT_104 = NL + "\t\t{" + NL + "\t\t\t/**" + NL + "\t\t\t * The child descriptors being populated." + NL + "\t\t\t * <!-- begin-user-doc -->" + NL + "\t\t\t * <!-- end-user-doc -->" + NL + "\t\t\t * @generated" + NL + "\t\t\t */" + NL + "\t\t\tprotected ";
  protected final String TEXT_105 = " newChildDescriptors;" + NL + "" + NL + "\t\t\t/**" + NL + "\t\t\t * The domain in which to create the children." + NL + "\t\t\t * <!-- begin-user-doc -->" + NL + "\t\t\t * <!-- end-user-doc -->" + NL + "\t\t\t * @generated" + NL + "\t\t\t */" + NL + "\t\t\tprotected ";
  protected final String TEXT_106 = " editingDomain;" + NL + "" + NL + "\t\t\t/**" + NL + "\t\t\t * Creates the a switch for populating child descriptors in the given domain." + NL + "\t\t\t * <!-- begin-user-doc -->" + NL + "\t\t\t * <!-- end-user-doc -->" + NL + "\t\t\t * @generated" + NL + "\t\t\t */" + NL + "\t\t\tCreationSwitch(";
  protected final String TEXT_107 = " newChildDescriptors, ";
  protected final String TEXT_108 = " editingDomain) " + NL + "\t\t\t{" + NL + "\t\t\t\tthis.newChildDescriptors = newChildDescriptors;" + NL + "\t\t\t\tthis.editingDomain = editingDomain;" + NL + "\t\t\t}";
  protected final String TEXT_109 = NL + "\t\t\t/**" + NL + "\t\t\t * <!-- begin-user-doc -->" + NL + "\t\t\t * <!-- end-user-doc -->" + NL + "\t\t\t * @generated" + NL + "\t\t\t */";
  protected final String TEXT_110 = NL + "\t\t\t@Override";
  protected final String TEXT_111 = NL + "\t\t\tpublic ";
  protected final String TEXT_112 = "Object case";
  protected final String TEXT_113 = "(";
  protected final String TEXT_114 = " object)" + NL + "\t\t\t{";
  protected final String TEXT_115 = NL + "\t\t\t\tnewChildDescriptors.add" + NL + "\t\t\t\t\t(createChildParameter" + NL + "\t\t\t\t\t\t(";
  protected final String TEXT_116 = "," + NL + "\t\t\t\t\t\t ";
  protected final String TEXT_117 = ".createEntry" + NL + "\t\t\t\t\t\t\t(";
  protected final String TEXT_118 = ",";
  protected final String TEXT_119 = NL + "\t\t\t\t\t\t\t ";
  protected final String TEXT_120 = ".create(";
  protected final String TEXT_121 = "))));";
  protected final String TEXT_122 = NL + "\t\t\t\t\t\t\t ";
  protected final String TEXT_123 = ".create";
  protected final String TEXT_124 = "())));";
  protected final String TEXT_125 = NL + "\t\t\t\tnewChildDescriptors.add" + NL + "\t\t\t\t\t(createChildParameter" + NL + "\t\t\t\t\t\t(";
  protected final String TEXT_126 = "," + NL + "\t\t\t\t\t\t ";
  protected final String TEXT_127 = ".createEntry" + NL + "\t\t\t\t\t\t\t(";
  protected final String TEXT_128 = ",";
  protected final String TEXT_129 = NL + "\t\t\t\t\t\t\t ";
  protected final String TEXT_130 = ")));";
  protected final String TEXT_131 = NL + "\t\t\t\t\t\t\t ";
  protected final String TEXT_132 = ")));";
  protected final String TEXT_133 = NL + "\t\t\t\t\t\t\t ";
  protected final String TEXT_134 = ".createFromString(";
  protected final String TEXT_135 = ", ";
  protected final String TEXT_136 = "))));";
  protected final String TEXT_137 = " // TODO: ensure this is a valid literal value";
  protected final String TEXT_138 = NL + "\t\t\t\tnewChildDescriptors.add" + NL + "\t\t\t\t\t(createChildParameter" + NL + "\t\t\t\t\t\t(";
  protected final String TEXT_139 = ",";
  protected final String TEXT_140 = NL + "\t\t\t\t\t\t ";
  protected final String TEXT_141 = ".create(";
  protected final String TEXT_142 = ")));";
  protected final String TEXT_143 = NL + "\t\t\t\t\t\t ";
  protected final String TEXT_144 = ".create";
  protected final String TEXT_145 = "()));";
  protected final String TEXT_146 = NL + "\t\t\t\tnewChildDescriptors.add" + NL + "\t\t\t\t\t(createChildParameter" + NL + "\t\t\t\t\t\t(";
  protected final String TEXT_147 = ",";
  protected final String TEXT_148 = NL + "\t\t\t\t\t\t ";
  protected final String TEXT_149 = "));";
  protected final String TEXT_150 = NL + "\t\t\t\t\t\t ";
  protected final String TEXT_151 = "));";
  protected final String TEXT_152 = NL + "\t\t\t\t\t\t ";
  protected final String TEXT_153 = ".createFromString(";
  protected final String TEXT_154 = ", ";
  protected final String TEXT_155 = ")));";
  protected final String TEXT_156 = " // TODO: ensure this is a valid literal value";
  protected final String TEXT_157 = NL;
  protected final String TEXT_158 = NL + "\t\t\t\treturn null;" + NL + "\t\t\t}" + NL + " ";
  protected final String TEXT_159 = NL + "\t\t\t/**" + NL + "\t\t\t * <!-- begin-user-doc -->" + NL + "\t\t\t * <!-- end-user-doc -->" + NL + "\t\t\t * @generated" + NL + "\t\t\t */" + NL + "\t\t\tprotected ";
  protected final String TEXT_160 = " createChildParameter(Object feature, Object child)" + NL + "\t\t\t{" + NL + "\t\t\t\treturn new ";
  protected final String TEXT_161 = "(null, feature, child);" + NL + "\t\t\t}" + NL + "" + NL + "\t\t}" + NL + "" + NL + "\t\t/**" + NL + "\t\t * <!-- begin-user-doc -->" + NL + "\t\t * <!-- end-user-doc -->" + NL + "\t\t * @generated" + NL + "\t\t */" + NL + "\t\tpublic ";
  protected final String TEXT_162 = " getNewChildDescriptors(Object object, ";
  protected final String TEXT_163 = " editingDomain)" + NL + "\t\t{" + NL + "\t\t\t";
  protected final String TEXT_164 = " result = new ";
  protected final String TEXT_165 = "();" + NL + "\t\t   new CreationSwitch(result, editingDomain).doSwitch((";
  protected final String TEXT_166 = ")object);" + NL + "\t\t   return result;" + NL + "\t\t}" + NL + "" + NL + "\t\t/**" + NL + "\t\t * <!-- begin-user-doc -->" + NL + "\t\t * <!-- end-user-doc -->" + NL + "\t\t * @generated" + NL + "\t\t */" + NL + "\t\tpublic ";
  protected final String TEXT_167 = " getResourceLocator()" + NL + "\t\t{" + NL + "\t\t\treturn ";
  protected final String TEXT_168 = ".INSTANCE;" + NL + "\t\t}" + NL + "\t}" + NL;
  protected final String TEXT_169 = NL + "}";
  protected final String TEXT_170 = NL;

  public String generate(Object argument)
  {
    final StringBuffer stringBuffer = new StringBuffer();
    
/**
 * Copyright (c) 2002-2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 */

    GenPackage genPackage = (GenPackage)argument; GenModel genModel=genPackage.getGenModel(); /* Trick to import java.util.* without warnings */Iterator.class.getName();
    stringBuffer.append(TEXT_1);
    stringBuffer.append(TEXT_2);
    {GenBase copyrightHolder = argument instanceof GenBase ? (GenBase)argument : argument instanceof Object[] && ((Object[])argument)[0] instanceof GenBase ? (GenBase)((Object[])argument)[0] : null;
    if (copyrightHolder != null && copyrightHolder.hasCopyright()) {
    stringBuffer.append(TEXT_3);
    stringBuffer.append(copyrightHolder.getCopyright(copyrightHolder.getGenModel().getIndentation(stringBuffer)));
    }}
    stringBuffer.append(TEXT_4);
    stringBuffer.append(genPackage.getProviderPackageName());
    stringBuffer.append(TEXT_5);
    genModel.addImport("org.eclipse.emf.common.notify.Adapter");
    genModel.addImport("org.eclipse.emf.common.notify.Notification");
    genModel.addImport("org.eclipse.emf.common.notify.Notifier");
    genModel.addImport("org.eclipse.emf.edit.provider.ChangeNotifier");
    genModel.addImport("org.eclipse.emf.edit.provider.ComposeableAdapterFactory");
    genModel.addImport("org.eclipse.emf.edit.provider.ComposedAdapterFactory");
    genModel.addImport("org.eclipse.emf.edit.provider.IChangeNotifier");
    genModel.addImport("org.eclipse.emf.edit.provider.IEditingDomainItemProvider");
    genModel.addImport("org.eclipse.emf.edit.provider.IItemLabelProvider");
    genModel.addImport("org.eclipse.emf.edit.provider.IItemPropertySource");
    genModel.addImport("org.eclipse.emf.edit.provider.INotifyChangedListener");
    genModel.addImport("org.eclipse.emf.edit.provider.IStructuredItemContentProvider");
    genModel.addImport("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
    boolean useGenerics = genModel.useGenerics();
    String _ArrayList = genModel.getImportedName(useGenerics ? "java.util.ArrayList<java.lang.Object>" : "java.util.ArrayList");
    String _Collection = genModel.getImportedName(useGenerics ? "java.util.Collection<java.lang.Object>" : "java.util.Collection");
    genModel.markImportLocation(stringBuffer);
    stringBuffer.append(TEXT_6);
    stringBuffer.append(genPackage.getItemProviderAdapterFactoryClassName());
    stringBuffer.append(TEXT_7);
    stringBuffer.append(genPackage.getImportedAdapterFactoryClassName());
    stringBuffer.append(TEXT_8);
    if (genPackage.isDisposableProviderFactory()) {
    stringBuffer.append(TEXT_9);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.edit.provider.IDisposable"));
    }
    if (genPackage.isExtensibleProviderFactory()) {
    stringBuffer.append(TEXT_10);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.edit.provider.IChildCreationExtender"));
    }
    stringBuffer.append(TEXT_11);
    if (genModel.hasCopyrightField()) {
    stringBuffer.append(TEXT_12);
    stringBuffer.append(genModel.getImportedName("java.lang.String"));
    stringBuffer.append(TEXT_13);
    stringBuffer.append(genModel.getCopyrightFieldLiteral());
    stringBuffer.append(TEXT_14);
    stringBuffer.append(genModel.getNonNLS());
    stringBuffer.append(TEXT_15);
    }
    stringBuffer.append(TEXT_16);
    if (genPackage.isDisposableProviderFactory() && genPackage.hasStatefulProvider()) {
    stringBuffer.append(TEXT_17);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.edit.provider.Disposable"));
    stringBuffer.append(TEXT_18);
    }
    if (genPackage.isExtensibleProviderFactory()) {
    stringBuffer.append(TEXT_19);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.edit.provider.ChildCreationExtenderManager"));
    stringBuffer.append(TEXT_20);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.edit.provider.ChildCreationExtenderManager"));
    stringBuffer.append(TEXT_21);
    stringBuffer.append(genPackage.getImportedEditPluginClassName());
    stringBuffer.append(TEXT_22);
    stringBuffer.append(genPackage.getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_23);
    }
    stringBuffer.append(TEXT_24);
    stringBuffer.append(_Collection);
    stringBuffer.append(TEXT_25);
    stringBuffer.append(_ArrayList);
    stringBuffer.append(TEXT_26);
    stringBuffer.append(genPackage.getItemProviderAdapterFactoryClassName());
    stringBuffer.append(TEXT_27);
    for (String name : genPackage.getProviderSupportedTypes()) {
    stringBuffer.append(TEXT_28);
    stringBuffer.append(genModel.getImportedName(name));
    stringBuffer.append(TEXT_29);
    }
    stringBuffer.append(TEXT_30);
    for (GenPackage genDelegate : genPackage.getAdapterDelegatePackages()) {
    stringBuffer.append(TEXT_31);
    stringBuffer.append(genDelegate.getImportedAdapterFactoryClassName());
    stringBuffer.append(TEXT_32);
    stringBuffer.append(genPackage.getUncapAdapterFactoryDelegateName(genDelegate));
    stringBuffer.append(TEXT_33);
    stringBuffer.append(genDelegate.getImportedAdapterFactoryClassName());
    stringBuffer.append(TEXT_34);
    stringBuffer.append(genPackage.getAdapterFactoryDelegateName(genDelegate));
    stringBuffer.append(TEXT_35);
    stringBuffer.append(genPackage.getUncapAdapterFactoryDelegateName(genDelegate));
    stringBuffer.append(TEXT_36);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.notify.AdapterFactory"));
    stringBuffer.append(TEXT_37);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.notify.AdapterFactory"));
    stringBuffer.append(TEXT_38);
    stringBuffer.append(genDelegate.getImportedAdapterFactoryClassName());
    stringBuffer.append(TEXT_39);
    stringBuffer.append(genDelegate.getImportedAdapterFactoryClassName());
    stringBuffer.append(TEXT_40);
    stringBuffer.append(genPackage.getUncapAdapterFactoryDelegateName(genDelegate));
    stringBuffer.append(TEXT_41);
    stringBuffer.append(genDelegate.getImportedAdapterFactoryClassName());
    stringBuffer.append(TEXT_42);
    stringBuffer.append(genPackage.getUncapAdapterFactoryDelegateName(genDelegate));
    stringBuffer.append(TEXT_43);
    }
    for (GenClass genClass : genPackage.getGenClasses()) {
    if (!genClass.isAbstract() && genClass.getProvider() != GenProviderKind.NONE_LITERAL) {
    if (genClass.isProviderSingleton()) {
    stringBuffer.append(TEXT_44);
    stringBuffer.append(genClass.getQualifiedInterfaceName());
    stringBuffer.append(TEXT_45);
    stringBuffer.append(genClass.getProviderClassName());
    stringBuffer.append(TEXT_46);
    stringBuffer.append(genClass.getUncapName());
    stringBuffer.append(TEXT_47);
    stringBuffer.append(genClass.getQualifiedInterfaceName());
    stringBuffer.append(TEXT_48);
    if (genModel.useClassOverrideAnnotation()) {
    stringBuffer.append(TEXT_49);
    }
    stringBuffer.append(TEXT_50);
    stringBuffer.append(genClass.getName());
    stringBuffer.append(TEXT_51);
    stringBuffer.append(genClass.getUncapName());
    stringBuffer.append(TEXT_52);
    stringBuffer.append(genClass.getUncapName());
    stringBuffer.append(TEXT_53);
    stringBuffer.append(genClass.getProviderClassName());
    stringBuffer.append(TEXT_54);
    stringBuffer.append(genClass.getUncapName());
    stringBuffer.append(TEXT_55);
    } else {
    stringBuffer.append(TEXT_56);
    stringBuffer.append(genClass.getQualifiedInterfaceName());
    stringBuffer.append(TEXT_57);
    if (genModel.useClassOverrideAnnotation()) {
    stringBuffer.append(TEXT_58);
    }
    stringBuffer.append(TEXT_59);
    stringBuffer.append(genClass.getName());
    stringBuffer.append(TEXT_60);
    stringBuffer.append(genClass.getProviderClassName());
    stringBuffer.append(TEXT_61);
    }
    }
    }
    for (GenClass genClass : genPackage.getAdapterDelegateSuperClasses()) {
    stringBuffer.append(TEXT_62);
    stringBuffer.append(genClass.getName());
    stringBuffer.append(TEXT_63);
    stringBuffer.append(genClass.getItemProviderAdapterFactoryClassName());
    stringBuffer.append(TEXT_64);
    stringBuffer.append(genClass.getName());
    stringBuffer.append(TEXT_65);
    stringBuffer.append(genClass.getItemProviderAdapterFactoryClassName());
    stringBuffer.append(TEXT_66);
    stringBuffer.append(genClass.getItemProviderAdapterFactoryClassName());
    stringBuffer.append(TEXT_67);
    stringBuffer.append(genClass.getName());
    stringBuffer.append(TEXT_68);
    }
    stringBuffer.append(TEXT_69);
    if (genModel.useClassOverrideAnnotation()) {
    stringBuffer.append(TEXT_70);
    }
    stringBuffer.append(TEXT_71);
    if (genModel.useClassOverrideAnnotation()) {
    stringBuffer.append(TEXT_72);
    }
    stringBuffer.append(TEXT_73);
    if (genModel.useClassOverrideAnnotation()) {
    stringBuffer.append(TEXT_74);
    }
    stringBuffer.append(TEXT_75);
    if (genModel.useGenerics()) {
    stringBuffer.append(TEXT_76);
    }
    stringBuffer.append(TEXT_77);
    if (genModel.getRuntimePlatform() == GenRuntimePlatform.GWT) {
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.util.Reflect"));
    stringBuffer.append(TEXT_78);
    if (genModel.useGenerics()) {
    stringBuffer.append(TEXT_79);
    }
    stringBuffer.append(TEXT_80);
    } else {
    stringBuffer.append(TEXT_81);
    if (genModel.useGenerics()) {
    stringBuffer.append(TEXT_82);
    }
    stringBuffer.append(TEXT_83);
    }
    stringBuffer.append(TEXT_84);
    if (genPackage.isDisposableProviderFactory() && genPackage.hasStatefulProvider()) {
    stringBuffer.append(TEXT_85);
    if (genModel.useClassOverrideAnnotation()) {
    stringBuffer.append(TEXT_86);
    }
    stringBuffer.append(TEXT_87);
    }
    if (genPackage.isExtensibleProviderFactory()) {
    stringBuffer.append(TEXT_88);
    stringBuffer.append(genModel.getImportedName(useGenerics ? "java.util.List<org.eclipse.emf.edit.provider.IChildCreationExtender>" : "java.util.List"));
    stringBuffer.append(TEXT_89);
    stringBuffer.append(genModel.getImportedName(useGenerics ? "java.util.Collection<?>" : "java.util.Collection"));
    stringBuffer.append(TEXT_90);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.edit.domain.EditingDomain"));
    stringBuffer.append(TEXT_91);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.util.ResourceLocator"));
    stringBuffer.append(TEXT_92);
    }
    stringBuffer.append(TEXT_93);
    if (genPackage.isDisposableProviderFactory()) {
    stringBuffer.append(TEXT_94);
    if (genPackage.hasStatefulProvider()) {
    stringBuffer.append(TEXT_95);
    } else {
    for (GenClass genClass : genPackage.getGenClasses()) {
    if (!genClass.isAbstract() && genClass.isProviderSingleton()) {
    stringBuffer.append(TEXT_96);
    stringBuffer.append(genClass.getUncapName());
    stringBuffer.append(TEXT_97);
    stringBuffer.append(genClass.getUncapName());
    stringBuffer.append(TEXT_98);
    }
    }
    }
    stringBuffer.append(TEXT_99);
    }
    if (genPackage.isChildCreationExtenders()) {
    for (Map.Entry<GenPackage, Map<GenClass, List<GenClass.ChildCreationData>>> packageEntry : genPackage.getExtendedChildCreationData().entrySet()) {
    stringBuffer.append(TEXT_100);
    stringBuffer.append(packageEntry.getKey().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_101);
    stringBuffer.append(genPackage.getChildCreationExtenderName(packageEntry.getKey()));
    stringBuffer.append(TEXT_102);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.edit.provider.IChildCreationExtender"));
    stringBuffer.append(TEXT_103);
    stringBuffer.append(genModel.getImportedName(packageEntry.getKey().getQualifiedSwitchClassName()));
    stringBuffer.append(useGenerics ? "<Object>" : "");
    stringBuffer.append(TEXT_104);
    stringBuffer.append(genModel.getImportedName(useGenerics ? "java.util.List<Object>" : "java.util.List"));
    stringBuffer.append(TEXT_105);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.edit.domain.EditingDomain"));
    stringBuffer.append(TEXT_106);
    stringBuffer.append(genModel.getImportedName(useGenerics ? "java.util.List<Object>" : "java.util.List"));
    stringBuffer.append(TEXT_107);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.edit.domain.EditingDomain"));
    stringBuffer.append(TEXT_108);
    for (Map.Entry<GenClass, List<GenClass.ChildCreationData>> classEntry : packageEntry.getValue().entrySet()) { GenClass genClass = classEntry.getKey();
    stringBuffer.append(TEXT_109);
    if (genModel.useClassOverrideAnnotation()) {
    stringBuffer.append(TEXT_110);
    }
    stringBuffer.append(TEXT_111);
    stringBuffer.append(genClass.getTypeParameters());
    stringBuffer.append(TEXT_112);
    stringBuffer.append(genPackage.getClassUniqueName(genClass));
    stringBuffer.append(TEXT_113);
    stringBuffer.append(genClass.getImportedInterfaceName());
    stringBuffer.append(genClass.getInterfaceTypeArguments());
    stringBuffer.append(TEXT_114);
    for (GenClass.ChildCreationData childCreationData : classEntry.getValue()) { GenFeature createFeature = childCreationData.createFeature; GenFeature delegatedFeature = childCreationData.delegatedFeature; GenClassifier createClassifier = childCreationData.createClassifier;
    if (createFeature.isFeatureMapType()) {
    if (delegatedFeature.isReferenceType()) { GenClass createClass = (GenClass)createClassifier;
    stringBuffer.append(TEXT_115);
    stringBuffer.append(createFeature.getQualifiedFeatureAccessor());
    stringBuffer.append(TEXT_116);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.util.FeatureMapUtil"));
    stringBuffer.append(TEXT_117);
    stringBuffer.append(delegatedFeature.getQualifiedFeatureAccessor());
    stringBuffer.append(TEXT_118);
    if (createClass.isMapEntry()) { 
    stringBuffer.append(TEXT_119);
    stringBuffer.append(createClass.getGenPackage().getQualifiedEFactoryInstanceAccessor());
    stringBuffer.append(TEXT_120);
    stringBuffer.append(createClass.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_121);
    } else {
    stringBuffer.append(TEXT_122);
    stringBuffer.append(createClass.getGenPackage().getQualifiedFactoryInstanceAccessor());
    stringBuffer.append(TEXT_123);
    stringBuffer.append(createClass.getName());
    stringBuffer.append(TEXT_124);
    }
    //ItemProvider/newChildDescriptorsReferenceDelegatedFeature.override.javajetinc
    } else { GenDataType createDataType = (GenDataType)createClassifier;
    stringBuffer.append(TEXT_125);
    stringBuffer.append(createFeature.getQualifiedFeatureAccessor());
    stringBuffer.append(TEXT_126);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.util.FeatureMapUtil"));
    stringBuffer.append(TEXT_127);
    stringBuffer.append(delegatedFeature.getQualifiedFeatureAccessor());
    stringBuffer.append(TEXT_128);
    if (delegatedFeature.isEnumBasedType()) {
    stringBuffer.append(TEXT_129);
    stringBuffer.append(delegatedFeature.getTypeGenEnum().getStaticValue(delegatedFeature.getEcoreFeature().getDefaultValueLiteral()));
    stringBuffer.append(TEXT_130);
    } else if (delegatedFeature.isStringBasedType()) {
    stringBuffer.append(TEXT_131);
    stringBuffer.append(delegatedFeature.getCreateChildValueLiteral());
    stringBuffer.append(TEXT_132);
    stringBuffer.append(genModel.getNonNLS());
    } else { String literal = delegatedFeature.getCreateChildValueLiteral();
    stringBuffer.append(TEXT_133);
    stringBuffer.append(createDataType.getGenPackage().getQualifiedEFactoryInstanceAccessor());
    stringBuffer.append(TEXT_134);
    stringBuffer.append(createDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_135);
    stringBuffer.append(literal);
    stringBuffer.append(TEXT_136);
    if (literal != null) {
    stringBuffer.append(genModel.getNonNLS());
    } else {
    stringBuffer.append(TEXT_137);
    }
    }
    //ItemProvider/newChildDescriptorsAttributeDelegatedFeature.override.javajetinc
    }
    } else if (createFeature.isReferenceType()) { GenClass createClass = (GenClass)createClassifier;
    stringBuffer.append(TEXT_138);
    stringBuffer.append(createFeature.getQualifiedFeatureAccessor());
    stringBuffer.append(TEXT_139);
    if (createClass.isMapEntry()) { 
    stringBuffer.append(TEXT_140);
    stringBuffer.append(createClass.getGenPackage().getQualifiedEFactoryInstanceAccessor());
    stringBuffer.append(TEXT_141);
    stringBuffer.append(createClass.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_142);
    } else {
    stringBuffer.append(TEXT_143);
    stringBuffer.append(createClass.getGenPackage().getQualifiedFactoryInstanceAccessor());
    stringBuffer.append(TEXT_144);
    stringBuffer.append(createClass.getName());
    stringBuffer.append(TEXT_145);
    }
    //ItemProvider/newChildDescriptorsReferenceFeature.override.javajetinc 
    } else { GenDataType createDataType = (GenDataType)createClassifier;
    stringBuffer.append(TEXT_146);
    stringBuffer.append(createFeature.getQualifiedFeatureAccessor());
    stringBuffer.append(TEXT_147);
    if (createFeature.isEnumBasedType()) {
    stringBuffer.append(TEXT_148);
    stringBuffer.append(createFeature.getTypeGenEnum().getStaticValue(createFeature.getEcoreFeature().getDefaultValueLiteral()));
    stringBuffer.append(TEXT_149);
    } else if (createFeature.isStringBasedType()) {
    stringBuffer.append(TEXT_150);
    stringBuffer.append(createFeature.getCreateChildValueLiteral());
    stringBuffer.append(TEXT_151);
    stringBuffer.append(genModel.getNonNLS());
    } else { String literal = createFeature.getCreateChildValueLiteral();
    stringBuffer.append(TEXT_152);
    stringBuffer.append(createDataType.getGenPackage().getQualifiedEFactoryInstanceAccessor());
    stringBuffer.append(TEXT_153);
    stringBuffer.append(createDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_154);
    stringBuffer.append(literal);
    stringBuffer.append(TEXT_155);
    if (literal != null) {
    stringBuffer.append(genModel.getNonNLS());
    } else {
    stringBuffer.append(TEXT_156);
    }
    }
    //ItemProvider/newChildDescriptorsAttributeFeature.override.javajetinc
    }
    stringBuffer.append(TEXT_157);
    }
    stringBuffer.append(TEXT_158);
    }
    stringBuffer.append(TEXT_159);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.edit.command.CommandParameter"));
    stringBuffer.append(TEXT_160);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.edit.command.CommandParameter"));
    stringBuffer.append(TEXT_161);
    stringBuffer.append(_Collection);
    stringBuffer.append(TEXT_162);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.edit.domain.EditingDomain"));
    stringBuffer.append(TEXT_163);
    stringBuffer.append(_ArrayList);
    stringBuffer.append(TEXT_164);
    stringBuffer.append(_ArrayList);
    stringBuffer.append(TEXT_165);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.EObject"));
    stringBuffer.append(TEXT_166);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.util.ResourceLocator"));
    stringBuffer.append(TEXT_167);
    stringBuffer.append(genPackage.getImportedEditPluginClassName());
    stringBuffer.append(TEXT_168);
    }
    }
    stringBuffer.append(TEXT_169);
    genModel.emitSortedImports();
    stringBuffer.append(TEXT_170);
    return stringBuffer.toString();
  }
}
