/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.ui.executionviewer.view;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.m2m.atl.profiler.core.ProfilerModelHandler;
import org.eclipse.m2m.atl.profiler.model.ExecutionError;
import org.eclipse.m2m.atl.profiler.model.ProfilingInstruction;
import org.eclipse.m2m.atl.profiler.model.ProfilingOperation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CallsViewLabelProvider
extends AdapterFactoryLabelProvider {
    private static final double TIME_CONSTANT = 1000.0;

    public CallsViewLabelProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public String getText(Object object) {
        String txt = "";
        NumberFormat percentInstance = DecimalFormat.getPercentInstance();
        percentInstance.setMaximumFractionDigits(2);
        if (object instanceof ProfilingOperation) {
            ProfilingOperation po = (ProfilingOperation)object;
            ProfilingOperation parentOp = po.getParentOperation();
            ProfilingOperation parentParentOp = parentOp.getParentOperation();
            ArrayList<ProfilingOperation> parentsList = new ArrayList<ProfilingOperation>();
            if (parentParentOp != null) {
                for (ProfilingInstruction tmpPi : parentParentOp.getExecutionInstructions()) {
                    if (!tmpPi.getContent().equals(parentOp.getContent())) continue;
                    parentsList.add((ProfilingOperation)tmpPi);
                }
            } else {
                parentsList.add(parentOp);
            }
            double avTime = 0.0;
            for (ProfilingOperation parent : parentsList) {
                for (ProfilingInstruction pi : parent.getExecutionInstructions()) {
                    if (!(pi instanceof ProfilingOperation) || !pi.getContent().equals(po.getContent())) continue;
                    ProfilingOperation tmpOp = (ProfilingOperation)pi;
                    double tmpTime = (double)(tmpOp.getEndTime() - tmpOp.getLaunchedTime()) / 1000.0;
                    avTime += tmpTime;
                }
            }
            double pTime = avTime / ProfilerModelHandler.getInstance().getModelTotalTime();
            txt = String.valueOf(po.getContent()) + " ";
            txt = pTime == 0.0 ? String.valueOf(txt) + "0.01 %" : String.valueOf(txt) + percentInstance.format(pTime);
        }
        return txt;
    }

    public Image getImage(Object object) {
        if (object instanceof ProfilingOperation) {
            ProfilingOperation pop = (ProfilingOperation)object;
            if (pop.isHasError()) {
                return this.getSystemErrorIcon();
            }
            return super.getImage(object);
        }
        if (object instanceof ExecutionError) {
            return this.getSystemErrorIcon();
        }
        return super.getImage(object);
    }

    private Image getSystemErrorIcon() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        return display.getSystemImage(1);
    }
}

