/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.eclipse;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.qvt.declarative.modelregistry.eclipse.ModelRegistryPlugin;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelSerializationRegistry;
import org.osgi.framework.Bundle;

public class ModelSerializationRegistryReader
extends RegistryReader {
    private static final String TAG_ENTRY = "entry";
    private static final String ATT_NAME = "name";
    private static final String ATT_FACTORY = "factory";
    private final ModelSerializationRegistry modelSerializationRegistry;

    public ModelSerializationRegistryReader(ModelSerializationRegistry modelSerializationRegistry) {
        super(Platform.getExtensionRegistry(), ModelRegistryPlugin.getDefault().getBundle().getSymbolicName(), "model_serialization");
        this.modelSerializationRegistry = modelSerializationRegistry;
    }

    protected boolean readElement(IConfigurationElement element) {
        IExtension extension = element.getDeclaringExtension();
        String namespaceIdentifier = extension.getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)namespaceIdentifier);
        if (element.getName().equals(TAG_ENTRY)) {
            String name = element.getAttribute(ATT_NAME);
            String factoryName = element.getAttribute(ATT_FACTORY);
            if (name == null) {
                ModelRegistryEnvironment.logError("Missing name for model serialization", null);
            } else if (factoryName == null) {
                ModelRegistryEnvironment.logError("Missing factory class for '" + name + "' model serialization", null);
            } else {
                this.modelSerializationRegistry.addSerializationFactoryDelegate(name, new BundleFactorySerialization(bundle, name, factoryName));
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BundleFactorySerialization
    extends ModelSerializationRegistry.FactorySerializationDelegate {
        protected final Bundle bundle;

        public BundleFactorySerialization(Bundle bundle, String serializationName, String className) {
            super(serializationName, className);
            this.bundle = bundle;
        }

        @Override
        protected Class<?> loadClass(String className) throws ClassNotFoundException {
            return this.bundle.loadClass(className);
        }
    }
}

