/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.relations.atlvm.runner;

import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationalTransformation;

public class ATLVMCodeJavaRunnerWriterParameters {
    protected RelationalTransformation transformation;
    protected URI transformationURI;
    protected URI sourceFolderURI;

    public ATLVMCodeJavaRunnerWriterParameters(Resource transformationResource, URI sourceFolderURI) {
        EObject eObject = (EObject)transformationResource.getContents().get(0);
        if (eObject instanceof RelationalTransformation) {
            this.transformation = (RelationalTransformation)eObject;
        }
        this.transformationURI = transformationResource.getURI();
        this.sourceFolderURI = sourceFolderURI;
    }

    public RelationalTransformation getTransformation() {
        return this.transformation;
    }

    public URI getTransformationURI() {
        return this.transformationURI;
    }

    public URI getSourceFolderURI() {
        return this.sourceFolderURI;
    }

    public String getBasePackage() {
        URI base = this.transformationURI.trimSegments(1).appendSegment("");
        URI relativeBase = base.deresolve(this.sourceFolderURI);
        if (relativeBase.hasTrailingPathSeparator()) {
            relativeBase = relativeBase.trimSegments(1);
        }
        String packageName = relativeBase.toFileString().replace(File.separator, ".");
        return packageName;
    }

    public String getClassName() {
        String unformatedName = this.transformation.getName();
        return String.valueOf(unformatedName.substring(0, 1).toUpperCase()) + unformatedName.substring(1);
    }

    public String getASMFileName() {
        URI fileURI = this.transformationURI.trimFileExtension();
        return fileURI.lastSegment();
    }
}

