/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.relations.atlvm.utils;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.qvt.declarative.execution.LabelledModel;

public class ASMEMFModelUtils {
    protected static EPackage getMetamodel(Resource resource) {
        EPackage result = null;
        EList contents = resource.getContents();
        if (contents.isEmpty()) {
            throw new IllegalArgumentException("Cannot find metamodel of the empty resource: " + resource);
        }
        result = ((EObject)resource.getContents().get(0)).eClass().getEPackage();
        return result;
    }

    protected static String getManageableURI(String uri) {
        return "uri:" + uri;
    }

    protected static String getManageableURI(EPackage ePackage) {
        return ASMEMFModelUtils.getManageableURI(ePackage.getNsURI());
    }

    public static ASMEMFModel getASMEMFModelFrom(EPackage ePackage, String alias) {
        String name = alias != null ? alias : ePackage.getName();
        try {
            ASMEMFModel result = ASMEMFModel.loadASMEMFModel((String)name, (ASMEMFModel)ASMEMFModel.createMOF(null), (String)ASMEMFModelUtils.getManageableURI(ePackage), null);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ASMEMFModel getASMEMFModelFrom(Resource resource, String name) throws Exception {
        resource.load(Collections.EMPTY_MAP);
        ASMEMFModel metamodel = ASMEMFModelUtils.getASMEMFModelFrom(ASMEMFModelUtils.getMetamodel(resource), null);
        return ASMEMFModel.loadASMEMFModel((String)name, (ASMEMFModel)metamodel, (URI)resource.getURI(), null);
    }

    protected static ASMEMFModel getASMEMFModelFrom(Resource resource, String name, ASMEMFModel metamodel) throws Exception {
        return ASMEMFModel.loadASMEMFModel((String)name, (ASMEMFModel)metamodel, (URI)resource.getURI(), null);
    }

    protected static Resource getResourceFrom(File file, boolean autoCreate) throws IOException, CoreException {
        URI fileURI = URI.createFileURI((String)file.getPath());
        if (!file.exists() && autoCreate) {
            file.createNewFile();
            Resource resource = ASMEMFModel.getResourceSet().createResource(fileURI);
            resource.save(null);
            return resource;
        }
        Resource resource = ASMEMFModel.getResourceSet().getResource(fileURI, true);
        return resource;
    }

    protected static File getFileFrom(URI uri) throws Exception {
        return new File(uri.toFileString());
    }

    protected static ASMEMFModel getASMEMFModelFromDynamicEcore(URI modelURI, String name) {
        Resource modelResource = ASMEMFModel.getResourceSet().getResource(modelURI, true);
        EPackage mainPackage = null;
        for (EObject object : modelResource.getContents()) {
            String nsURI;
            if (!(object instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)object;
            if (mainPackage == null) {
                mainPackage = ePackage;
            }
            if ((nsURI = ePackage.getNsURI()) == null) {
                throw new IllegalArgumentException("Invalid metamodel with no NS URI:" + modelResource);
            }
            ASMEMFModel.getResourceSet().getPackageRegistry().put((Object)nsURI, (Object)ePackage);
        }
        ASMEMFModel result = ASMEMFModelUtils.getASMEMFModelFrom(mainPackage, name);
        return result;
    }

    public static ASMEMFModel getASMEMFModelFrom(LabelledModel labelledModel, boolean autoCreate) throws Exception {
        URI metamodelURI;
        URI modelURI = URI.createURI((String)labelledModel.getAccessor(), (boolean)false);
        if (modelURI.isRelative()) {
            modelURI = URI.createPlatformResourceURI((String)labelledModel.getAccessor(), (boolean)false);
        }
        if ((metamodelURI = URI.createURI((String)labelledModel.getMetamodel().getAccessor(), (boolean)false)).isRelative()) {
            metamodelURI = URI.createPlatformResourceURI((String)labelledModel.getMetamodel().getAccessor(), (boolean)false);
        }
        ASMEMFModel metamodel = null;
        String modelName = labelledModel.getName();
        String metamodelName = labelledModel.getMetamodel().getName();
        metamodel = metamodelURI.isFile() || metamodelURI.isPlatformResource() ? ASMEMFModelUtils.getASMEMFModelFromDynamicEcore(metamodelURI, labelledModel.getMetamodel().getName()) : (metamodelURI.toString().equals("http://www.eclipse.org/emf/2002/Ecore") ? ASMEMFModel.createMOF(null) : ASMEMFModel.loadASMEMFModel((String)metamodelName, (ASMEMFModel)ASMEMFModel.createMOF(null), (String)ASMEMFModelUtils.getManageableURI(metamodelURI.toString()), null));
        File modelFile = ASMEMFModelUtils.getFileFrom(modelURI);
        Resource modelResource = ASMEMFModelUtils.getResourceFrom(modelFile, autoCreate);
        ASMEMFModel result = ASMEMFModelUtils.getASMEMFModelFrom(modelResource, modelName, metamodel);
        result.setIsTarget(true);
        return result;
    }
}

