/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.launching;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.resource.BasicProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.debug.launching.QVTiLaunchConfigurationDelegate;
import org.eclipse.qvtd.debug.launching.QVTimperativeJob;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class QVTinterpretedJob
extends QVTimperativeJob {
    protected QVTinterpretedJob(@NonNull QVTiLaunchConfigurationDelegate launchConfigurationDelegate, @NonNull ILaunch launch, @NonNull ILaunchConfiguration configuration) throws CoreException {
        super("QVTi Interpreted Job", launchConfigurationDelegate, launch, configuration);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        int LOAD_TX_TICKS = 5;
        int USED_PACKAGES_TICKS = this.inMap.size();
        int CHECKING_TICKS = this.outMap.size();
        int EXECUTING_TICKS = 50;
        int SAVING_TICKS = this.outMap.size();
        int allTicks = LOAD_TX_TICKS + USED_PACKAGES_TICKS + CHECKING_TICKS + EXECUTING_TICKS + SAVING_TICKS + this.inMap.size() + this.outMap.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)allTicks);
        try {
            QVTiEnvironmentFactory environmentFactory = new QVTiEnvironmentFactory(BasicProjectManager.CLASS_PATH, null);
            if (this.traceEvaluation) {
                environmentFactory.setEvaluationTracingEnabled(true);
            }
            subMonitor.split(LOAD_TX_TICKS, 0).beginTask("Loading '" + this.txURI + "'", LOAD_TX_TICKS);
            ImperativeTransformation transformation = QVTimperativeUtil.loadTransformation((QVTbaseEnvironmentFactory)environmentFactory, (URI)this.txURI, (boolean)environmentFactory.keepDebug());
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            subMonitor.split(USED_PACKAGES_TICKS, 0).beginTask("Loading used packages for '" + this.txURI + "'", USED_PACKAGES_TICKS);
            QVTiExecutor executor = this.launchConfigurationDelegate.createExecutor(environmentFactory, transformation);
            for (TypedModel typedModel : ClassUtil.nullFree((EList)transformation.getModelParameter())) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                for (Package asPackage : ClassUtil.nullFree((EList)typedModel.getUsedPackage())) {
                    String nsURI;
                    EObject esObject = asPackage.getESObject();
                    if (!(esObject instanceof EPackage) || (nsURI = ((EPackage)esObject).getNsURI()) == null) continue;
                    environmentFactory.getResourceSet().getPackageRegistry().put((Object)nsURI, (Object)esObject);
                }
            }
            for (String inName : this.inMap.keySet()) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (inName == null) continue;
                URI inURI = URI.createURI((String)((String)this.inMap.get(inName)), (boolean)true);
                subMonitor.split(1, 0).beginTask("Loading '" + inURI + "'", 1);
                executor.loadModel(inName, inURI, null);
            }
            for (String outName : this.outMap.keySet()) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (outName == null) continue;
                URI outURI = URI.createURI((String)((String)this.outMap.get(outName)), (boolean)true);
                subMonitor.split(1, 0).beginTask("Creating '" + outURI + "'", 1);
                executor.createModel(outName, outURI, null);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            subMonitor.split(CHECKING_TICKS, 0).beginTask("Checking loaded models for '" + this.txURI + "'", CHECKING_TICKS);
            executor.checkModels();
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            subMonitor.split(EXECUTING_TICKS, 0).beginTask("Executing '" + this.txURI + "'", EXECUTING_TICKS);
            executor.execute();
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            subMonitor.split(SAVING_TICKS, 0).beginTask("Saving output models for '" + this.txURI + "'", SAVING_TICKS);
            executor.saveModels();
            Status status = new Status(0, this.getPluginId(), null);
            return status;
        }
        catch (OperationCanceledException oce) {
            try {
                this.streamsProxy.getErrWriter().write("Cancelled");
            }
            catch (IOException e) {
                this.noThrow(e);
            }
            throw oce;
        }
        catch (Throwable t) {
            if (t instanceof WrappedException) {
                t = t.getCause();
            }
            StringWriter sw = new StringWriter();
            sw.append("Failed to execute '" + this.txURI + "'\n");
            t.printStackTrace(new PrintWriter(sw));
            String consoleMessage = sw.toString().replaceAll("\\r\\n", "\n");
            try {
                this.streamsProxy.getErrWriter().write(consoleMessage);
            }
            catch (IOException e) {
                this.noThrow(e);
            }
            String popUpMessage = "Failed to execute '" + this.txURI + "' - see console for more details.";
            Status status = new Status(4, this.getPluginId(), popUpMessage, t);
            StatusManager.getManager().handle((IStatus)status, 2);
            String logMessage = popUpMessage;
            Status status2 = new Status(1, this.getPluginId(), logMessage, t);
            return status2;
        }
        finally {
            monitor.done();
        }
    }
}

