/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractCompilationUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.BundleModuleHandle;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxMessages;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleBlackboxProvider
extends JavaBlackboxProvider {
    private static final String EXTENSION_POINT = "javaBlackboxUnits";
    private static final String UNIT_ELEM = "unit";
    private static final String LIBRARY_ELEM = "library";
    private static final String CLASS_ATTR = "class";
    private static final String NAME_ATTR = "name";
    private static final String NAMESPACE_ATTR = "namespace";
    private static final String DESC_ATTR = "description";
    private static final String METAMODEL_ELEM = "metamodel";
    private static final String NSURI_ATTR = "nsURI";
    private Map<String, AbstractCompilationUnitDescriptor> fDescriptorMap;

    private Map<String, AbstractCompilationUnitDescriptor> readDescriptors() {
        IConfigurationElement[] configs;
        LinkedHashMap<String, AbstractCompilationUnitDescriptor> descriptors = new LinkedHashMap<String, AbstractCompilationUnitDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.m2m.qvt.oml", EXTENSION_POINT);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                BundleDescriptor descriptor = this.createDescriptor(element);
                String id = descriptor.getQualifiedName();
                if (!descriptors.containsKey(id)) {
                    descriptors.put(id, descriptor);
                } else {
                    String message = NLS.bind(JavaBlackboxMessages.UnitAlreadyRegisteredContributionIgnored, id, descriptor.getContributorId());
                    QvtPlugin.error(message);
                }
            }
            catch (IllegalArgumentException e) {
                QvtPlugin.error("Failed to read java black-box definition: " + e.getMessage());
            }
            ++n2;
        }
        return descriptors;
    }

    private BundleDescriptor createDescriptor(IConfigurationElement configurationElement) throws IllegalArgumentException {
        if (UNIT_ELEM.equals(configurationElement.getName())) {
            String name = configurationElement.getAttribute(NAME_ATTR);
            String namespace = configurationElement.getAttribute(NAMESPACE_ATTR);
            if (namespace == null) {
                namespace = configurationElement.getContributor().getName();
            }
            String description = configurationElement.getAttribute(DESC_ATTR);
            String qualifiedName = namespace.length() == 0 ? name : String.valueOf(namespace) + "." + name;
            return new BundleDescriptor(configurationElement, qualifiedName, description);
        }
        if (LIBRARY_ELEM.equals(configurationElement.getName())) {
            return new BundleDescriptor(configurationElement, BundleBlackboxProvider.deriveQualifiedNameFromSimpleDefinition(configurationElement), null);
        }
        throw new IllegalArgumentException("Unsupported configuration element " + configurationElement);
    }

    private static String deriveQualifiedNameFromSimpleDefinition(IConfigurationElement moduleElement) {
        String className = moduleElement.getAttribute(CLASS_ATTR);
        String name = moduleElement.getAttribute(NAME_ATTR);
        if (name == null) {
            return className;
        }
        String packageName = BundleBlackboxProvider.getPackageNameFromJavaClass(className);
        if (packageName == null) {
            return name;
        }
        return String.valueOf(packageName) + "." + name;
    }

    @Override
    public AbstractCompilationUnitDescriptor getModuleDescriptor(String qualifiedName, ResolutionContext resolutionContext) {
        return this.getDescriptorMap().get(qualifiedName);
    }

    public Collection<AbstractCompilationUnitDescriptor> getModuleDescriptors(ResolutionContext resolutionContext) {
        return this.getDescriptorMap().values();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.fDescriptorMap = null;
    }

    private Map<String, AbstractCompilationUnitDescriptor> getDescriptorMap() {
        if (this.fDescriptorMap != null) {
            return this.fDescriptorMap;
        }
        this.fDescriptorMap = EMFPlugin.IS_ECLIPSE_RUNNING ? this.readDescriptors() : Collections.emptyMap();
        return this.fDescriptorMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BundleDescriptor
    extends JavaBlackboxProvider.JavaUnitDescriptor {
        private String fContributingBundleId;

        BundleDescriptor(IConfigurationElement configurationElement, String unitQualifiedName, String description) {
            super(BundleBlackboxProvider.this, unitQualifiedName);
            this.fContributingBundleId = configurationElement.getContributor().getName();
            if (configurationElement.getName().equals(BundleBlackboxProvider.LIBRARY_ELEM)) {
                this.addModuleHandle(configurationElement);
            } else {
                IConfigurationElement[] libraries;
                IConfigurationElement[] iConfigurationElementArray = libraries = configurationElement.getChildren(BundleBlackboxProvider.LIBRARY_ELEM);
                int n = libraries.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement moduleElement = iConfigurationElementArray[n2];
                    this.addModuleHandle(moduleElement);
                    ++n2;
                }
            }
        }

        String getContributorId() {
            return this.fContributingBundleId;
        }

        private void addModuleHandle(IConfigurationElement moduleElement) {
            String bundleId = moduleElement.getContributor().getName();
            String className = moduleElement.getAttribute(BundleBlackboxProvider.CLASS_ATTR);
            String moduleName = moduleElement.getAttribute(BundleBlackboxProvider.NAME_ATTR);
            if (moduleName == null) {
                moduleName = BundleBlackboxProvider.getSimpleNameFromJavaClass(className);
            }
            BundleModuleHandle moduleHandle = new BundleModuleHandle(bundleId, className, moduleName, this.readUsedPackagesNsURIs(moduleElement));
            this.addModuleHandle(moduleHandle);
        }

        private List<String> readUsedPackagesNsURIs(IConfigurationElement moduleConfigElement) {
            ArrayList<String> uris = new ArrayList<String>(3);
            IConfigurationElement[] iConfigurationElementArray = moduleConfigElement.getChildren(BundleBlackboxProvider.METAMODEL_ELEM);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement nextElement = iConfigurationElementArray[n2];
                String nsURI = nextElement.getAttribute(BundleBlackboxProvider.NSURI_ATTR);
                if (nsURI != null) {
                    uris.add(nsURI);
                }
                ++n2;
            }
            return uris;
        }
    }
}

