/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline;

import com.google.inject.Inject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.resource.EObjectHandleImpl;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.outline.ContentOutlineNode;
import org.eclipse.xtext.ui.editor.outline.IContentOutlineNodeFactory;
import org.eclipse.xtext.ui.editor.outline.OutlineLabelProvider;
import org.eclipse.xtext.ui.editor.outline.actions.ContentOutlineNodeAdapter;
import org.eclipse.xtext.ui.editor.outline.actions.ContentOutlineNodeAdapterFactory;
import org.eclipse.xtext.util.TextLocation;
import org.eclipse.xtext.util.concurrent.IEObjectHandle;
import org.eclipse.xtext.util.concurrent.IStateAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContentOutlineNodeFactory
implements IContentOutlineNodeFactory {
    @Inject
    @OutlineLabelProvider
    private ILabelProvider labelProvider;
    @Inject
    private ILocationInFileProvider locationProvider;

    public DefaultContentOutlineNodeFactory() {
    }

    public DefaultContentOutlineNodeFactory(ILabelProvider styledLabelProvider, ILocationInFileProvider locationProvider) {
        this.labelProvider = styledLabelProvider;
        this.locationProvider = locationProvider;
    }

    @Override
    public ContentOutlineNode create(IStateAccess<XtextResource> resourceAccess, EObject semanticNode, ContentOutlineNode outlineParentNode) {
        ContentOutlineNode result = new ContentOutlineNode(this.getText(semanticNode), this.getImage(semanticNode), this.getRegion(semanticNode), this.getEObjectHandle(semanticNode, resourceAccess), this.getEClass(semanticNode));
        if (outlineParentNode != null) {
            outlineParentNode.addChildren(result);
        }
        if (semanticNode != null) {
            ContentOutlineNodeAdapter outlineAdapter = (ContentOutlineNodeAdapter)ContentOutlineNodeAdapterFactory.INSTANCE.adapt((Notifier)semanticNode, ContentOutlineNode.class);
            outlineAdapter.setContentOutlineNode(result);
        }
        return result;
    }

    protected EClass getEClass(EObject semanticNode) {
        if (semanticNode != null) {
            return semanticNode.eClass();
        }
        return null;
    }

    protected StyledString getText(EObject semanticNode) {
        StyledString text = this.labelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider ? ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.labelProvider).getStyledText((Object)semanticNode) : new StyledString(this.labelProvider.getText((Object)semanticNode));
        return text;
    }

    protected Image getImage(EObject semanticNode) {
        return this.labelProvider.getImage((Object)semanticNode);
    }

    protected IRegion getRegion(EObject semanticNode) {
        TextLocation location = this.locationProvider.getLocation(semanticNode);
        return new Region(location.getOffset(), location.getLength());
    }

    protected IEObjectHandle<EObject> getEObjectHandle(EObject semanticNode, IStateAccess<XtextResource> resourceAccess) {
        if (semanticNode != null) {
            return new EObjectHandleImpl(semanticNode, resourceAccess);
        }
        return null;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public ILocationInFileProvider getLocationProvider() {
        return this.locationProvider;
    }
}

