/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.bracketmatching;

import com.google.inject.Inject;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.bracketmatching.BracketMatchingUnitOfWork;
import org.eclipse.xtext.ui.editor.bracketmatching.IBracketMatcher;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;

public class CharacterPairMatcher
implements ICharacterPairMatcher,
IDocumentListener,
IXtextModelListener {
    private IXtextDocument document;
    @Inject
    private IBracketMatcher bracketMatcher;
    private boolean changes = false;

    public void dispose() {
        this.clear();
    }

    public void clear() {
        this.document.removeDocumentListener(this);
        this.document.removeModelListener(this);
        this.changes = false;
    }

    public IRegion match(IDocument iDocument, int offset) {
        IXtextDocument doc = this.getDocument(iDocument);
        if (!this.changes) {
            return BracketMatchingUnitOfWork.match(doc, this.bracketMatcher, offset);
        }
        return null;
    }

    protected IXtextDocument getDocument(IDocument iDocument) {
        if (this.document != null && this.document != iDocument) {
            this.clear();
            this.document = null;
        }
        if (this.document == null) {
            this.document = (IXtextDocument)iDocument;
            this.document.addDocumentListener(this);
            this.document.addModelListener(this);
        }
        return this.document;
    }

    public int getAnchor() {
        return 1;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.changes = true;
    }

    public void modelChanged(XtextResource resource) {
        this.changes = false;
    }
}

