/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;
import org.eclipse.xtext.resource.ClasspathUriUtil;
import org.eclipse.xtext.resource.IClasspathUriResolver;
import org.eclipse.xtext.util.Wrapper;

public class JdtClasspathUriResolver
implements IClasspathUriResolver {
    private IJavaElement javaElement;

    public URI resolve(Object context, URI classpathUri) {
        if (!(context instanceof IJavaElement)) {
            throw new IllegalArgumentException("Context must implement IResource");
        }
        this.javaElement = (IJavaElement)context;
        try {
            if (ClasspathUriUtil.isClasspathUri((URI)classpathUri)) {
                IJavaProject javaProject = this.javaElement.getJavaProject();
                URI result = this.findResourceInWorkspace(javaProject, classpathUri);
                if (classpathUri.fragment() != null) {
                    result = result.appendFragment(classpathUri.fragment());
                }
                return result;
            }
        }
        catch (Exception exc) {
            throw new ClasspathUriResolutionException(exc);
        }
        return classpathUri;
    }

    protected URI findResourceInWorkspace(IJavaProject javaProject, URI classpathUri) throws JavaModelException, CoreException {
        if (javaProject.exists()) {
            String path = classpathUri.trimSegments(1).path();
            String fullPath = classpathUri.path();
            final String name = classpathUri.lastSegment();
            String packageName = path.substring(1).replace('/', '.');
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                IPackageFragment foundElement = packageFragmentRoot.getPackageFragment(packageName);
                if (foundElement instanceof IPackageFragment && foundElement.exists()) {
                    IPackageFragment packageFragment = foundElement;
                    IResource packageFragmentResource = packageFragment.getResource();
                    if (packageFragmentResource == null || packageFragmentResource instanceof IFile) {
                        Object[] nonJavaResources;
                        Object[] objectArray = nonJavaResources = packageFragment.getNonJavaResources();
                        int n3 = nonJavaResources.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object nonJavaResource = objectArray[n4];
                            IJarEntryResource jarEntryResource = (IJarEntryResource)nonJavaResource;
                            if (packageFragmentRoot.isArchive()) {
                                if (fullPath.equals(jarEntryResource.getFullPath().toString())) {
                                    IResource packageFragmentRootResource = packageFragmentRoot.getResource();
                                    if (packageFragmentRootResource != null) {
                                        URI packageFragmentRootURI = this.createPlatformResourceURI(packageFragmentRootResource);
                                        URI result = this.createArchiveURI(packageFragmentRootURI, fullPath);
                                        return result;
                                    }
                                    IPath packageFragmentRootPath = packageFragmentRoot.getPath();
                                    URI packageFragmentRootURI = URI.createFileURI((String)packageFragmentRootPath.toString());
                                    URI result = this.createArchiveURI(packageFragmentRootURI, fullPath);
                                    return result;
                                }
                            } else {
                                String nonJavaResourceName = jarEntryResource.getName();
                                if (name.equals(nonJavaResourceName) && packageFragmentRoot.isExternal()) {
                                    if (!(packageFragmentRoot instanceof ExternalPackageFragmentRoot)) {
                                        throw new IllegalStateException();
                                    }
                                    IResource resource = ((ExternalPackageFragmentRoot)packageFragmentRoot).resource();
                                    IPath absolutePath = resource.getFullPath();
                                    absolutePath = absolutePath.append(fullPath);
                                    return this.createPlatformResourceURI(absolutePath);
                                }
                            }
                            ++n4;
                        }
                    } else {
                        final Wrapper result = Wrapper.wrap(null);
                        packageFragmentResource.accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                if (name.equals(resource.getName())) {
                                    result.set((Object)resource);
                                }
                                return result.get() == null;
                            }
                        }, 1, 0);
                        if (result.get() != null) {
                            return this.createPlatformResourceURI((IResource)result.get());
                        }
                    }
                }
                ++n2;
            }
        }
        return classpathUri;
    }

    protected URI createArchiveURI(URI baseURI, String entryPath) {
        URI result = URI.createURI((String)("archive:" + baseURI.toString() + "!" + entryPath));
        return result;
    }

    protected URI createPlatformResourceURI(IResource resource) {
        IPath resourcePath = resource.getFullPath();
        return this.createPlatformResourceURI(resourcePath);
    }

    private URI createPlatformResourceURI(IPath resourcePath) {
        URI result = URI.createPlatformResourceURI((String)resourcePath.toString(), (boolean)true);
        return result;
    }
}

