/*
* generated by Xtext
*/
package org.eclipse.xtext.example.ui.outline;

import java.util.Collections;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.example.fowlerdsl.Command;
import org.eclipse.xtext.example.fowlerdsl.Event;
import org.eclipse.xtext.example.fowlerdsl.State;
import org.eclipse.xtext.example.fowlerdsl.Statemachine;
import org.eclipse.xtext.ui.editor.outline.ContentOutlineNode;
import org.eclipse.xtext.ui.editor.outline.transformer.AbstractDeclarativeSemanticModelTransformer;

/**
 * customization of the default outline structure
 * 
 */
public class FowlerDslTransformer extends AbstractDeclarativeSemanticModelTransformer {

	public boolean consumeNode(Statemachine statemachine) {
		return true;
	}

	public ContentOutlineNode createNode(Statemachine statemachine, ContentOutlineNode outlineParentNode) {
		ContentOutlineNode result = super.createNode(statemachine, outlineParentNode);
		if (!statemachine.getEvents().isEmpty()) {
			ContentOutlineNode events = new ContentOutlineNode("events");
			result.getChildren().add(events);
			for (Event event : statemachine.getEvents())
				transformSemanticNode(event, events);
		}
		if (!statemachine.getCommands().isEmpty()) {
			ContentOutlineNode commands = new ContentOutlineNode("commands");
			result.getChildren().add(commands);
			for (Command command : statemachine.getCommands())
				transformSemanticNode(command, commands);
		}
		if (!statemachine.getStates().isEmpty()) {
			ContentOutlineNode states = new ContentOutlineNode("states");
			result.getChildren().add(states);
			for (State state : statemachine.getStates())
				transformSemanticNode(state, states);
		}
		return result;
	}

	public List<EObject> getChildren(Statemachine statemachine) {
		return Collections.emptyList();
	}

}
