/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.LinkedList;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.IDamagerRepairer;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.XtextPresentationReconciler;
import org.eclipse.xtext.ui.editor.autoedit.DefaultAutoEditStrategy;
import org.eclipse.xtext.ui.editor.contentassist.IContentAssistantFactory;
import org.eclipse.xtext.ui.editor.formatting.IContentFormatterFactory;
import org.eclipse.xtext.ui.editor.hover.ProblemHover;
import org.eclipse.xtext.ui.editor.quickfix.XtextQuickAssistAssistant;
import org.eclipse.xtext.ui.editor.toggleComments.ISingleLineCommentHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    @Inject
    private IContentAssistantFactory contentAssistantFactory;
    @Inject
    private IHyperlinkDetector detector;
    @Inject
    private Provider<IReconciler> reconcilerProvider;
    @Inject(optional=true)
    private Provider<IDamagerRepairer> damagerRepairerProvider;
    @Inject(optional=true)
    private IContentFormatterFactory contentFormatterFactory;
    @Inject(optional=true)
    private ISingleLineCommentHelper singleLineCommentHelper;
    @Inject
    private Provider<XtextQuickAssistAssistant> quickAssistAssistentProvider;
    @Inject
    private Provider<XtextPresentationReconciler> presentationReconcilerProvider;
    @Inject(optional=true)
    private IQuickAssistAssistant quickAssistant;
    @Inject(optional=true)
    private IAutoEditStrategy autoEditStrategy;
    @Inject
    private DefaultAutoEditStrategy defaultEditStrategy;

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new ProblemHover(sourceViewer);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new ProblemHover(sourceViewer);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        return this.contentAssistantFactory.createConfiguredAssistant((SourceViewerConfiguration)this, sourceViewer);
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        IReconciler reconciler = (IReconciler)this.reconcilerProvider.get();
        return reconciler;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.damagerRepairerProvider != null) {
            XtextPresentationReconciler reconciler = (XtextPresentationReconciler)((Object)this.getPresentationReconcilerProvider().get());
            reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            IDamagerRepairer defDR = (IDamagerRepairer)this.damagerRepairerProvider.get();
            reconciler.setRepairer(defDR.getRepairer(), "__dftl_partition_content_type");
            reconciler.setDamager(defDR.getDamager(), "__dftl_partition_content_type");
            return reconciler;
        }
        return super.getPresentationReconciler(sourceViewer);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        LinkedList<IHyperlinkDetector> detectors = new LinkedList<IHyperlinkDetector>();
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (inheritedDetectors != null) {
            IHyperlinkDetector[] iHyperlinkDetectorArray = inheritedDetectors;
            int n = inheritedDetectors.length;
            int n2 = 0;
            while (n2 < n) {
                final IHyperlinkDetector detector = iHyperlinkDetectorArray[n2];
                detectors.add(new IHyperlinkDetector(){

                    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
                        try {
                            return detector.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    }
                });
                ++n2;
            }
        }
        detectors.add(this.detector);
        return detectors.toArray(new IHyperlinkDetector[detectors.size()]);
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (sourceViewer.isEditable()) {
            if (this.quickAssistant == null) {
                this.quickAssistant = (IQuickAssistAssistant)this.quickAssistAssistentProvider.get();
            }
            return this.quickAssistant;
        }
        return null;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        if (this.contentFormatterFactory != null) {
            return this.contentFormatterFactory.createConfiguredFormatter((SourceViewerConfiguration)this, sourceViewer);
        }
        return super.getContentFormatter(sourceViewer);
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        if (this.singleLineCommentHelper != null) {
            return this.singleLineCommentHelper.getDefaultPrefixes(sourceViewer, contentType);
        }
        return super.getDefaultPrefixes(sourceViewer, contentType);
    }

    public void setSingleLineCommentHelper(ISingleLineCommentHelper singleLineCommentHelper) {
        this.singleLineCommentHelper = singleLineCommentHelper;
    }

    public ISingleLineCommentHelper getSingleLineCommentHelper() {
        return this.singleLineCommentHelper;
    }

    public void setPresentationReconcilerProvider(Provider<XtextPresentationReconciler> presentationReconcilerProvider) {
        this.presentationReconcilerProvider = presentationReconcilerProvider;
    }

    public Provider<XtextPresentationReconciler> getPresentationReconcilerProvider() {
        return this.presentationReconcilerProvider;
    }

    protected IAutoEditStrategy internalGetEditStrategy() {
        if (this.autoEditStrategy == null) {
            return this.defaultEditStrategy;
        }
        return this.autoEditStrategy;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.internalGetEditStrategy() instanceof ISourceViewerAware) {
            ((ISourceViewerAware)this.internalGetEditStrategy()).setSourceViewer(sourceViewer);
        }
        return new IAutoEditStrategy[]{new DefaultIndentLineAutoEditStrategy(), this.internalGetEditStrategy()};
    }
}

