/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.quickfix;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.eclipse.xtext.ui.MarkerUtil;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;

public class XtextResourceMarkerAnnotationModel
extends ResourceMarkerAnnotationModel {
    private final IssueResolutionProvider issueResolutionProvider;
    private final MarkerUtil markerUtil;

    public XtextResourceMarkerAnnotationModel(IFile file, IssueResolutionProvider issueResolutionProvider, MarkerUtil markerUtil) {
        super((IResource)file);
        this.issueResolutionProvider = issueResolutionProvider;
        this.markerUtil = markerUtil;
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        MarkerAnnotation annotation = super.createMarkerAnnotation(marker);
        String issueCode = this.markerUtil.getCode((Annotation)annotation);
        annotation.setQuickFixable(this.issueResolutionProvider.hasResolutionFor(issueCode));
        return annotation;
    }

    public void fireAnnotationChangedEvent(Annotation annotation) {
        this.queueAnnotationChanged(annotation);
        this.fireQueuedEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAnnotationChanged(Annotation annotation) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.getAnnotationModelEvent().annotationChanged(annotation);
        }
    }

    public void fireQueuedEvents() {
        this.fireModelChanged();
    }
}

