/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.jvmmodel;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IDerivedStateComputer;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class JvmModelAssociator
implements IJvmModelAssociations,
IJvmModelAssociator,
ILogicalContainerProvider,
IDerivedStateComputer {
    private static final Logger LOG = Logger.getLogger(JvmModelAssociator.class);
    @Inject
    @Named(value="languageName")
    private String languageName;
    @Inject
    private IReferableElementsUnloader.GenericUnloader unloader;
    @Inject
    private IJvmModelInferrer inferrer;

    protected Adapter getOrInstall(Resource resource) {
        if (!(resource instanceof XtextResource)) {
            return new Adapter();
        }
        if (!this.languageName.equals(((XtextResource)resource).getLanguageName())) {
            return new Adapter();
        }
        Adapter adapter = (Adapter)EcoreUtil.getAdapter((List)resource.eAdapters(), Adapter.class);
        if (adapter == null) {
            adapter = new Adapter();
            resource.eAdapters().add((Object)adapter);
        }
        return adapter;
    }

    protected Map<EObject, JvmIdentifiableElement> getLogicalContainerMapping(Resource resource) {
        return this.getOrInstall((Resource)resource).logicalContainerMap;
    }

    @Override
    public XExpression getAssociatedExpression(JvmIdentifiableElement element) {
        if (element == null) {
            return null;
        }
        Map<EObject, JvmIdentifiableElement> mapping = this.getLogicalContainerMapping(element.eResource());
        for (Map.Entry<EObject, JvmIdentifiableElement> entry : mapping.entrySet()) {
            if (entry.getValue() != element || !(entry.getKey() instanceof XExpression)) continue;
            return (XExpression)entry.getKey();
        }
        return null;
    }

    @Override
    public JvmIdentifiableElement getLogicalContainer(EObject object) {
        if (object == null) {
            return null;
        }
        Map<EObject, JvmIdentifiableElement> mapping = this.getLogicalContainerMapping(object.eResource());
        if (mapping.containsKey(object)) {
            return mapping.get(object);
        }
        if (object.eContainer() != null && !mapping.containsKey(object.eContainer())) {
            Set<EObject> elements = this.getJvmElements(object.eContainer());
            for (EObject eObject : elements) {
                if (!(eObject instanceof JvmIdentifiableElement)) continue;
                return (JvmIdentifiableElement)eObject;
            }
        }
        return null;
    }

    @Override
    public JvmIdentifiableElement getNearestLogicalContainer(EObject context) {
        if (context == null) {
            return null;
        }
        JvmIdentifiableElement locicalContainer = this.getLogicalContainer(context);
        if (locicalContainer != null) {
            return locicalContainer;
        }
        return this.getNearestLogicalContainer(context.eContainer());
    }

    @Override
    public void associateLogicalContainer(EObject logicalChild, JvmIdentifiableElement element) {
        if (logicalChild == null) {
            return;
        }
        Map<EObject, JvmIdentifiableElement> mapping = this.getLogicalContainerMapping(logicalChild.eResource());
        if (mapping.containsKey(logicalChild)) {
            throw new IllegalStateException("There is already a logical container for " + logicalChild);
        }
        mapping.put(logicalChild, element);
    }

    protected ListMultimap<EObject, EObject> sourceToTargetMap(Resource res) {
        return this.getOrInstall((Resource)res).sourceToTargetMap;
    }

    protected Resource getResource(Notifier ctx) {
        Resource res = null;
        if (ctx instanceof EObject) {
            res = ((EObject)ctx).eResource();
        } else if (ctx instanceof Resource) {
            res = (Resource)ctx;
        }
        if (res == null) {
            throw new IllegalArgumentException("Argument must either be an EObject (cotained in a resource) or a resource. But was " + ctx);
        }
        return res;
    }

    @Override
    public void associate(EObject sourceElement, EObject jvmElement) {
        if (sourceElement != null) {
            ListMultimap<EObject, EObject> map = this.sourceToTargetMap(sourceElement.eResource());
            map.put((Object)sourceElement, (Object)jvmElement);
        }
    }

    @Override
    public void associatePrimary(EObject sourceElement, EObject jvmElement) {
        if (sourceElement != null) {
            ListMultimap<EObject, EObject> map = this.sourceToTargetMap(sourceElement.eResource());
            if (map.containsKey((Object)sourceElement)) {
                map.get((Object)sourceElement).add(0, jvmElement);
            } else {
                map.put((Object)sourceElement, (Object)jvmElement);
            }
        }
    }

    @Override
    public Set<EObject> getJvmElements(EObject sourceElement) {
        ListMultimap<EObject, EObject> sourceToTargetMap = this.sourceToTargetMap(sourceElement.eResource());
        List elements = sourceToTargetMap.get((Object)sourceElement);
        return Sets.newLinkedHashSet((Iterable)elements);
    }

    @Override
    public Set<EObject> getSourceElements(EObject jvmElement) {
        ListMultimap<EObject, EObject> map = this.sourceToTargetMap(jvmElement.eResource());
        LinkedHashSet sourceElements = Sets.newLinkedHashSet();
        for (Map.Entry entry : map.entries()) {
            if (entry.getValue() != jvmElement) continue;
            sourceElements.add((EObject)entry.getKey());
        }
        return sourceElements;
    }

    @Override
    public EObject getPrimarySourceElement(EObject jvmElement) {
        ListMultimap<EObject, EObject> map = this.sourceToTargetMap(jvmElement.eResource());
        for (Map.Entry entry : map.entries()) {
            if (entry.getValue() != jvmElement) continue;
            return (EObject)entry.getKey();
        }
        return null;
    }

    public void installDerivedState(final DerivedStateAwareResource resource, boolean isPreLinkingPhase) {
        if (resource.getContents().isEmpty()) {
            return;
        }
        EObject eObject = (EObject)resource.getContents().get(0);
        this.inferrer.infer(eObject, new IAcceptor<JvmDeclaredType>(){

            public void accept(JvmDeclaredType t) {
                if (t != null) {
                    resource.getContents().add((Object)t);
                }
            }
        }, isPreLinkingPhase);
    }

    public void discardDerivedState(DerivedStateAwareResource resource) {
        this.cleanAssociationState((Resource)resource);
    }

    public void cleanAssociationState(Resource resource) {
        ArrayList derived = Lists.newArrayList();
        EList resourcesContentsList = resource.getContents();
        int i = 1;
        while (i < resourcesContentsList.size()) {
            EObject eObject = (EObject)resourcesContentsList.get(i);
            this.unloader.unloadRoot(eObject);
            derived.add(eObject);
            ++i;
        }
        resourcesContentsList.removeAll((Collection)derived);
        this.sourceToTargetMap(resource).clear();
        this.getLogicalContainerMapping(resource).clear();
    }

    protected static class Adapter
    extends AdapterImpl {
        public ListMultimap<EObject, EObject> sourceToTargetMap = LinkedListMultimap.create();
        public Map<EObject, JvmIdentifiableElement> logicalContainerMap = Maps.newHashMap();

        protected Adapter() {
        }

        public boolean isAdapterForType(Object type) {
            return Adapter.class == type;
        }
    }
}

