/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.search;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.search.Messages;
import org.eclipse.xtext.ui.search.XtextEObjectSearchDialog;

public class IteratorJob
extends Job {
    private static final int TIME_THRESHOLD = 250;
    private Iterator<IEObjectDescription> iterator;
    private List<IEObjectDescription> matches;
    private final XtextEObjectSearchDialog dialog;

    public IteratorJob(XtextEObjectSearchDialog dialog) {
        super(Messages.IteratorJob_SearchJobName);
        this.dialog = dialog;
        this.setSystem(true);
    }

    public void init(Iterable<IEObjectDescription> matchResult) {
        this.iterator = matchResult.iterator();
        this.matches = Lists.newArrayList();
    }

    protected IStatus run(IProgressMonitor monitor) {
        long startTime = System.currentTimeMillis();
        while (this.iterator.hasNext()) {
            IEObjectDescription next = this.iterator.next();
            if (next.getQualifiedName() == null || next.getEObjectURI() == null || next.getEClass() == null) continue;
            this.matches.add(next);
            long endTime = System.currentTimeMillis();
            if (this.matches.size() != this.dialog.getHeightInChars() && endTime - startTime <= 250L) continue;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.dialog.updateMatches(this.sortedCopy(this.matches), false);
            startTime = System.currentTimeMillis();
        }
        this.dialog.updateMatches(this.sortedCopy(this.matches), true);
        return Status.OK_STATUS;
    }

    private Collection<IEObjectDescription> sortedCopy(Iterable<IEObjectDescription> list) {
        ArrayList result = Lists.newArrayList(this.matches);
        Collections.sort(result, new Comparator<IEObjectDescription>(){

            @Override
            public int compare(IEObjectDescription o1, IEObjectDescription o2) {
                int diff = o1.getQualifiedName().compareToIgnoreCase(o2.getQualifiedName());
                if (diff == 0) {
                    String className1 = o1.getEClass().getName();
                    String className2 = o2.getEClass().getName();
                    if (className1 == null) {
                        diff = className2 == null ? 0 : -1;
                    } else {
                        int n = diff = className2 == null ? 1 : className1.compareToIgnoreCase(className2);
                    }
                    if (diff == 0) {
                        diff = o1.getEObjectURI().toString().compareTo(o2.getEObjectURI().toString());
                    }
                }
                return diff;
            }
        });
        return result;
    }
}

