/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.contentassist;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.ide.editor.contentassist.antlr.ContentAssistContextFactory;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Exceptions;

@Singleton
public class ContentAssistService {
    public static final int DEFAULT_PROPOSALS_LIMIT = 1000;
    @Inject
    private Provider<ContentAssistContextFactory> contextFactoryProvider;
    @Inject
    private ExecutorService executorService;
    @Inject
    private IdeContentProposalProvider proposalProvider;
    @Inject
    private Provider<IdeContentProposalAcceptor> proposalAcceptorProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public CompletionList createCompletionList(Document document, XtextResource resource, CompletionParams params, CancelIndicator cancelIndicator) {
        try {
            Position caretPosition;
            int caretOffset;
            IdeContentProposalAcceptor acceptor;
            CompletionList result;
            block5: {
                result = new CompletionList();
                result.setIsIncomplete(true);
                acceptor = (IdeContentProposalAcceptor)this.proposalAcceptorProvider.get();
                acceptor.setCancelIndicator(cancelIndicator);
                caretOffset = document.getOffSet(params.getPosition());
                caretPosition = params.getPosition();
                TextRegion position = new TextRegion(caretOffset, 0);
                try {
                    this.createProposals(document.getContents(), position, caretOffset, resource, acceptor);
                }
                catch (Throwable t) {
                    if (this.operationCanceledManager.isOperationCanceledException(t)) break block5;
                    throw t;
                }
            }
            int idx = 0;
            for (ContentAssistEntry it : acceptor.getEntries()) {
                CompletionItem item = this.toCompletionItem(it, caretOffset, caretPosition, document);
                item.setSortText(Strings.padStart((String)Integer.toString(idx), (int)5, (char)'0'));
                result.getItems().add(item);
                ++idx;
            }
            return result;
        }
        catch (Throwable e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    protected void createProposals(String document, TextRegion selection, int caretOffset, XtextResource resource, IIdeContentProposalAcceptor acceptor) {
        if (caretOffset > document.length()) {
            return;
        }
        ContentAssistContextFactory contextFactory = (ContentAssistContextFactory)this.contextFactoryProvider.get();
        contextFactory.setPool(this.executorService);
        ContentAssistContext[] contexts = contextFactory.create(document, (ITextRegion)selection, caretOffset, resource);
        this.proposalProvider.createProposals(Arrays.asList(contexts), acceptor);
    }

    protected CompletionItem toCompletionItem(ContentAssistEntry entry, int caretOffset, Position caretPosition, Document document) {
        CompletionItem completionItem = new CompletionItem();
        String label = entry.getLabel();
        if (label == null) {
            label = entry.getProposal();
        }
        completionItem.setLabel(label);
        completionItem.setDetail(entry.getDescription());
        completionItem.setDocumentation(entry.getDocumentation());
        String prefix = entry.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        int prefixOffset = caretOffset - prefix.length();
        Position prefixPosition = document.getPosition(prefixOffset);
        completionItem.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(prefixPosition, caretPosition), entry.getProposal())));
        completionItem.setKind(this.translateKind(entry));
        if (!entry.getTextReplacements().isEmpty()) {
            if (completionItem.getAdditionalTextEdits() == null) {
                completionItem.setAdditionalTextEdits(new ArrayList(entry.getTextReplacements().size()));
            }
            entry.getTextReplacements().forEach(it -> completionItem.getAdditionalTextEdits().add(this.toTextEdit((ReplaceRegion)it, document)));
        }
        if ("SNIPPET".equals(entry.getKind())) {
            completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        }
        return completionItem;
    }

    protected CompletionItemKind translateKind(ContentAssistEntry entry) {
        if (entry.getKind() != null) {
            switch (entry.getKind()) {
                case "CLASS": {
                    return CompletionItemKind.Class;
                }
                case "COLOR": {
                    return CompletionItemKind.Color;
                }
                case "CONSTRUCTOR": {
                    return CompletionItemKind.Constructor;
                }
                case "ENUM": {
                    return CompletionItemKind.Enum;
                }
                case "FIELD": {
                    return CompletionItemKind.Field;
                }
                case "FILE": {
                    return CompletionItemKind.File;
                }
                case "FUNCTION": {
                    return CompletionItemKind.Function;
                }
                case "INTERFACE": {
                    return CompletionItemKind.Interface;
                }
                case "KEYWORD": {
                    return CompletionItemKind.Keyword;
                }
                case "METHOD": {
                    return CompletionItemKind.Method;
                }
                case "MODULE": {
                    return CompletionItemKind.Module;
                }
                case "PROPERTY": {
                    return CompletionItemKind.Property;
                }
                case "REFERENCE": {
                    return CompletionItemKind.Reference;
                }
                case "SNIPPET": {
                    return CompletionItemKind.Snippet;
                }
                case "TEXT": {
                    return CompletionItemKind.Text;
                }
                case "UNIT": {
                    return CompletionItemKind.Unit;
                }
                case "VALUE": {
                    return CompletionItemKind.Value;
                }
                case "VARIABLE": {
                    return CompletionItemKind.Variable;
                }
            }
            return CompletionItemKind.Value;
        }
        return CompletionItemKind.Value;
    }

    protected TextEdit toTextEdit(ReplaceRegion region, Document doc) {
        Position start = this.getPosition(doc, region.getOffset());
        Position end = this.getPosition(doc, region.getEndOffset());
        return new TextEdit(new Range(start, end), region.getText());
    }

    private Position getPosition(Document doc, int offset) {
        int docLength = doc.getContents().length();
        return offset > docLength ? doc.getPosition(docLength) : doc.getPosition(offset);
    }
}

