/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.linking.lazy;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.linking.lazy.LazyLinker;
import org.eclipse.xtext.linking.lazy.SyntheticLinkingLeafNode;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;

public class SyntheticLinkingSupport {
    @Inject
    private LazyLinker lazyLinker;

    public void createAndSetProxy(EObject obj, EReference eRef, String crossRefString) {
        this.createAndSetProxy(obj, eRef, crossRefString, 0, 1);
    }

    public void createAndSetProxy(EObject obj, EReference eRef, String crossRefString, int offset, int length) {
        INode crossReferenceNode = this.createCrossReferenceNode(obj, eRef, crossRefString, offset, length);
        this.lazyLinker.createAndSetProxy(obj, crossReferenceNode, eRef);
    }

    protected INode createCrossReferenceNode(EObject obj, EReference eRef, String crossRefString, int offset, int length) {
        CompositeNode parent = this.getParent(obj, eRef, crossRefString, offset, length);
        EObject grammarElement = this.getGrammarElement(obj, eRef, crossRefString, offset, length);
        return new SyntheticLinkingLeafNode(obj, crossRefString, offset, length, grammarElement, parent);
    }

    protected EObject getGrammarElement(EObject obj, EReference eRef, String crossRefString, int offset, int length) {
        return XtextFactory.eINSTANCE.createKeyword();
    }

    protected CompositeNode getParent(EObject obj, EReference eRef, String crossRefString, int offset, int length) {
        ICompositeNode rootNode;
        IParseResult parseResult;
        ICompositeNode rootNode2;
        ICompositeNode node = NodeModelUtils.getNode(obj);
        if (node != null && (rootNode2 = node.getRootNode()) instanceof CompositeNode) {
            return (CompositeNode)rootNode2;
        }
        Resource resource = obj.eResource();
        if (resource instanceof XtextResource && (parseResult = ((XtextResource)resource).getParseResult()) != null && (rootNode = parseResult.getRootNode()) instanceof CompositeNode) {
            return (CompositeNode)rootNode;
        }
        return null;
    }
}

