/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.view;

import org.eclipse.core.internal.utils.WrappedRuntimeException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtend.ide.view.DerivedSourceView;
import org.eclipse.xtend.ide.view.Messages;
import org.eclipse.xtext.util.ITextRegion;

public class OpenEditorAction
extends Action {
    private static final String COMPILATION_UNIT_EDITOR_ID = "org.eclipse.jdt.ui.CompilationUnitEditor";
    private DerivedSourceView derivedSourceView;
    private IFile inputFile;
    private ITextRegion selectedRegion;

    void setInputFile(IFile selectedFile) {
        if (selectedFile == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        this.inputFile = selectedFile;
    }

    void setSelectedRegion(ITextRegion textRegion) {
        this.selectedRegion = textRegion;
    }

    public OpenEditorAction(DerivedSourceView derivedSourceView) {
        Assert.isNotNull((Object)((Object)derivedSourceView));
        this.derivedSourceView = derivedSourceView;
        JavaPluginImages.setLocalImageDescriptors((IAction)this, (String)"goto_input.gif");
        this.setText(Messages.OpenEditorAction_Label);
        this.setToolTipText(Messages.OpenEditorAction_ToolTip);
        this.setDescription(Messages.OpenEditorAction_Description);
    }

    public void run() {
        if (this.inputFile == null) {
            return;
        }
        IWorkbenchPartSite workbenchPartSite = this.derivedSourceView.getSite();
        IWorkbenchPage workbenchPage = workbenchPartSite.getPage();
        try {
            IEditorPart editorPart = workbenchPage.openEditor((IEditorInput)new FileEditorInput(this.inputFile), COMPILATION_UNIT_EDITOR_ID, true, 3);
            if (this.selectedRegion != null) {
                ((ITextEditor)editorPart).selectAndReveal(this.selectedRegion.getOffset(), this.selectedRegion.getLength());
            }
        }
        catch (PartInitException partInitException) {
            throw new WrappedRuntimeException((Throwable)partInitException);
        }
    }
}

