/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import java.util.regex.Pattern;

public class TraceFileNameProvider {
    public static final String TRACE_FILE_EXTENSION = "._trace";
    private static final Pattern TRACE_FILE_NAME_PATTERN = Pattern.compile(".*/?\\..+\\._trace$");

    public boolean isTraceFileName(String traceFileName) {
        return TRACE_FILE_NAME_PATTERN.matcher(traceFileName).matches();
    }

    public String getTraceFromJava(String javaFileName) {
        int i = javaFileName.lastIndexOf(47);
        if (i < 0) {
            return "." + javaFileName + TRACE_FILE_EXTENSION;
        }
        return String.valueOf(javaFileName.substring(0, i + 1)) + "." + javaFileName.substring(i + 1) + TRACE_FILE_EXTENSION;
    }

    public String getJavaFromTrace(String traceFileName) {
        int i = traceFileName.lastIndexOf(47);
        if (i < 0) {
            return traceFileName.substring(1, traceFileName.length() - TRACE_FILE_EXTENSION.length());
        }
        return String.valueOf(traceFileName.substring(0, i + 1)) + traceFileName.substring(i + 2, traceFileName.length() - TRACE_FILE_EXTENSION.length());
    }
}

